#pragma rtGlobals=1		// Use modern global access method.


Function/WAVE SepWaves(filename,item,ItemName)
	string filename,ItemName
	variable item
	
	variable dimx=DimSize($filename,0)
	wave/Z w=$filename
	if(waveexists(w)==0)
		print GetDatafolder(0)
		return NaN
	endif
	Duplicate/O/R=[0,dimX][item,item] $filename,$itemname
	wave SepWave=$ItemName
	Redimension/N=-1 SepWave //Modified by Carlos
	Redimension/S SepWave
	return SepWave

end

Function SepWave3D(FileName,N)
	wave FileName
	variable N
	
	variable i
	string NewName
	variable j=floor(DimSize(FileName,2)/N)
	
	for(i=0;i<j;i+=1)
		
		
		NewName="stack_"+num2str(i+1)
		duplicate/R=[][][i*N,(i+1)*N-1] FileName, $NewName			
		wave w=$NewName
		
		if(i!=0)
			wave A=wavecalculatorW(0,solution,w)
		else
			duplicate w,wt
			wave A=wavecalculatorW(0,w,wt)
			wavecalculatorV(3,2,A)
			killwaves wt	
		endif
	endfor

end

function AddWaves()

	string ALName=wavelist("F_ionto",";","")
	string WaveNam
	variable i
	
	for(i=0;i<itemsinlist(ALName);i+=1)
		Wavenam=StringFromList(i,ALName,";")
		concatenate/KILL/NP=0 {$Wavenam},Ca_Pool
	endfor
	
end

Function Statall()

	string wp=wavelist("TL*",";","")
	variable i
	for(i=0;i<ItemsInList(wp);i+=1) 
		make/O/n=(1,6) temp
		wave w=sepwaves(stringfromlist(i,wp),0,"iCa")
		wavestats w
		temp[0][0]=V_avg
		temp[0][1]=V_sdev
		temp[0][2]=V_sem
		temp[0][3]=V_max
		temp[0][4]=V_min
		temp[0][5]=V_sdev/V_avg
		concatenate/KILL/NP=0 {temp}, CellReport
		killwaves w
	endfor
	make/O/n=(1,6) temp
	wave CaAvg
	wavestats CaAvg
	temp[0][0]=V_avg
	temp[0][1]=V_sdev
	temp[0][2]=V_sem
	temp[0][3]=V_max
	temp[0][4]=V_min
	temp[0][5]=V_sdev/V_avg	
	concatenate/KILL/NP=0 {temp}, CellReport
end

Function MultipleLoad()

	NewPath currentfolder
	string AllFile = Indexedfile(currentfolder,-1,".ibw")
	string aw
	string LoadingWave
	variable i
	for(i=0;i<itemsinlist(allFile);i+=1)
		Loadingwave = stringfromlist(i,AllFile,";")
		loadwave/H/W/A/P=currentfolder Loadingwave
		aw=wavelist("*",";","")
		rename $stringfromlist(ItemsInList(aw)-1,aw), $loadingwave		
	endfor
end

function GetDataFolderList()
	variable i
	String/G Folderlist=""
	for(i=0;i<countobjects(":",4);i+=1)
		FolderList=folderlist+";"+Getindexedobjname(":",4,i)		
	endfor
	
end

Macro movewaves(): panel
		
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(1098,110,1398,310)
	ShowTools/A
	getdatafolderlist()
	string folderlist
	PopupMenu popup0,pos={1,2},size={118,21},proc=selectsource
	PopupMenu popup0,mode=28,popvalue=stringfromlist(0,folderlist,";"),value= #"folderlist"
	
	getdatafolderlist()
	PopupMenu popup1,pos={21,78},size={47,21},proc=selectdestandmove
	PopupMenu popup1,mode=28,popvalue=stringfromlist(0,folderlist,";"),value= #"folderlist"

endmacro

Function selectsource(pa) : PopupMenuControl
	STRUCT WMPopupAction &pa

	switch( pa.eventCode )
		case 2: // mouse up
			Variable popNum = pa.popNum
			String popStr = pa.popStr
			setdatafolder :$popstr
			string sourcefolder=getdatafolder(1)
			setdatafolder root:working_folder			
			break
	endswitch

	return 0
End

Function selectdestandmove(pa) : PopupMenuControl
	STRUCT WMPopupAction &pa

	switch( pa.eventCode )
		case 2: // mouse up
			Variable popNum = pa.popNum
			String popStr = pa.popStr
			setdatafolder :$popstr
			string destFolder=Getdatafolder(1)
			string sourcefolder
			variable i
			setdatafolder sourcefolder
			string waveslist=wavelist("AVG*","",";")

			for(i=0;i<itemsinlist(waveslist,";");i+=1)
				duplicate $stringfromlist(i,waveslist,";"), $destFolder
			endfor  			
			break
	endswitch

	return 0
End


function trace2movie(traceWave,mode)
	WAVE traceWave
	VARIABLE mode
	
	string pointWaveName
	string partialWaveName
	string PictureName
	variable i
	for(i=0;i<Dimsize(traceWave,0);i+=1)
		pointWaveName="Point_"+num2str(i)
		switch(mode)
			case 0:
				partialWaveName=NameOfWave(traceWave)
			case 1:
				partialWaveName="P_trace"+num2str(i)
				duplicate/O/R=[0,i] traceWave, $partialWaveName
		endswitch		
		pictureName="trace_"+num2str(i)+".png"
		make/n=1 $pointWaveName
		duplicate/O/R=[i,i] traceWave, $pointWaveName
		Display $partialWaveName
		SetAxis left,wavemin(tracewave),wavemax(tracewave)
		SetAxis bottom,DimOffset(tracewave,0),DimOffSet(tracewave,0)+DimSize(tracewave,0)*DimDelta(tracewave,0)
		ModifyGraph rgb($partialWaveName)=(65535,65535,65535),lsize($partialWaveName)=1.0
		AppendToGraph $pointWaveName
		ModifyGraph mode($pointWaveName)=3,marker($pointWaveName)=19, rgb($pointWaveName)=(65280,0,0),mrkThick($pointWaveName)=3
//		ModifyGraph gbRGB=(0,0,0),wbRGB=(0,0,0)
		ModifyGraph nticks(bottom)=0,axThick(bottom)=0,noLabel(bottom)=2
		ModifyGraph nticks(left)=0,axThick(left)=0,noLabel(left)=2
//		SavePICT /P=home/c=1/E=-7/B=288/RES=50 as picturename
		SavePICT/P=home/E=-5/c=1/TRAN=1/B=288/RES=50 as picturename
		DoWindow/K graph1
	endfor


end

function showandsave()
	string ListWaveName=wavelist("slice*",";","")
	variable i
	
	string WaveNamex,cmd
	string picturename
	for(i=0;i<itemsinlist(listwavename);i+=1)
		
		Newimage/K=0 $stringfromlist(i,listwavename,";")
		waveNamex=stringfromlist(i,listwavename,";")
		picturename=waveNamex+".tif"
		modifyimage $waveNamex ctab={0,150,YellowHot,0}
		execute cmd
		ModifyGraph nticks(top)=0,noLabel(top)=2
		ModifyGraph nticks(left)=0,noLabel(left)=2
		ModifyGraph margin=1
		ModifyGraph gbRGB=(0,0,0),wbRGB=(0,0,0)
		
		SavePICT /P=home/c=1/E=-7/B=288/RES=200 as picturename
//		setscale/P x,0,0.164,um,$stringfromlist(i,listwavename,";")
//		setscale/P y,0,0.164,um,$stringfromlist(i,listwavename,";")
		DoWindow/K graph1
		
	endfor

end

function savegraph()
	string graphName=WinList("Graph*",";","WIN:1")
	string picturename
	variable i
	for(i=0;i<ItemsInList(GraphName);i+=1)
		picturename=stringfromlist(i,graphname)+".EMF"
		SavePICT/P=Igor/E=-2/Win=$stringfromlist(i,graphname) as picturename
	endfor


end


function closewindow()
	variable i
	string graphname="graph"
	
	for(i=91;i>0;i-=1)
	graphname="graph"+num2str(i)
	DoWindow/K $graphname
	endfor
end

function Group(From,To)
	variable From,To
	
	string AllFiles,daFiles,FolderName
	variable i,j
	NewPath CurrentFolder
	AllFiles=IndexedFile(CurrentFolder,-1,".da" )
	
	For(i=0;i<ItemsInList(AllFiles);i+=1)
		STRING/G $stringfromlist(i,Allfiles)=stringfromlist(i,Allfiles)
	endfor

	daFiles=stringlist("*appended*",";")
	For(i=From-1;i<=To-1;i+=1)
		FolderName = num2str(0)+num2str(i+1)
		copyfolder/P=currentFolder "New Folder" as FolderName
		movefile/D/P=currentFolder stringfromlist(i,daFiles,";") as FolderName
	endfor

end

Function SelectbyCa()

	string AllWaves=WaveList("*",";","")
	variable i,j
	
	for(i=0;i<ItemsInList(Allwaves);i+=1)
		Wave w=$stringfromlist(i,AllWaves)
		for(j=0;j<DimSize(w,0);j+=1)
			if(w[j][7]!=0)
				duplicate/R=[j,j][0,DimSize(w,1)] w, temp
				concatenate/NP=0/KILL {temp},Ca_Pool
			else
			endif
		endfor
		
	endfor

end

Function SelectbyVh()

	wave Ca_Pool
	variable i
	
	for(i=0;i<DimSize(Ca_Pool,0);i+=1)
		if(Ca_Pool[i][4]<1.5e-04 && Ca_Pool[i][4]>1.0e-06)
			duplicate/R=[i,i][0,DimSize(Ca_Pool,1)] Ca_Pool, temp
			concatenate/NP=0/KILL {temp},Vh_Pool
		else
		endif	
	endfor

end

function AddWavesZ()

	string ALName=wavelist("TL*",";","")
	string WaveNam
	variable i,j=0
	
	wave Z0
	
	for(i=0;i<itemsinlist(ALName);i+=1)
		Wavenam=StringFromList(i,ALName,";")
		wave w=$Wavenam
		for(j=0;j<DimSize(w,0);j+=1)
			w[j][6]=w[j][6]-Z0[j]
			duplicate/R=[j,j][0,DimSize(w,1)] w, temp
		endfor
		concatenate/NP=0 {w}, Spots_Pool
	endfor
	
end

Function PPTDivider(from)  //N_Frames: Number of frames per section ; N_DepFrame: Number of frames at depolarization
	VARIABLE from

	
	Variable i,j

	string AFolders=ListFolder()
	
//////////////////////////////////// RENAME THE WAVES AS A STANDARD ORDER ///////////////////////////////////////////
		
	String PDepImon=Wavelist("PDep*1",";","")
	String PDepVmon=Wavelist("PDep*2",";","")
	String PDepLeak=Wavelist("PDep*3",";","")
	
/////////////////////////////////// DIVIDE THE FILES TO DIFFERENT SLICES //////////////////////////////////////////////////////
	
		
	for(j=0;j<ItemsInList(PDepImon);j+=1)
		movewave $Stringfromlist(j,PDepImon,";"), :$StringFromList(j+from,AFolders,";"):
		movewave $Stringfromlist(j,PDepVmon,";"), :$StringFromList(j+from,AFolders,";"):
		movewave $Stringfromlist(j,PDepLeak,";"), :$StringFromList(j+from,AFolders,";"):
		i+=1
	endfor			

	//
 	
End

function AlignCaonRb()
	wave RbProfile,CaProfile
	if(waveexists(RbProfile)==0 || waveexists(CaProfile)==0)
		return 0
	endif
	
	insertpoints/M=1 DimSize(RbProfile,1),3,RbProfile
	variable i,Ord
	for(i=0;i<DimSize(CaProfile,0);i+=1)
		Ord=CaProfile[i][DimSize(CaProfile,1)-1]
		if(Ord-floor(Ord)==0)
			RbProfile[Ord][DimSize(RbProfile,1)-3]=CaProfile[i][0]
			RbProfile[Ord][DimSize(RbProfile,1)-2]=CaProfile[i][1]
		else
		endif
	endfor
	RbProfile[][DimSize(RbProfile,1)-1]=NaN
end

function AlignAggrCa(a,b,c)
	variable a,b,c            //a: row in Ca, b:row in Rb, c: Same Ca ordder

	wave RbProfile,CaProfile
	if(waveexists(RbProfile)==0 || waveexists(CaProfile)==0)
		return 0
	endif
		
		RbProfile[b][DimSize(RbProfile,1)-3]=CaProfile[a][0]
		RbProfile[b][DimSize(RbProfile,1)-2]=CaProfile[a][1]
		RbProfile[b][DimSize(RbProfile,1)-1]=c
end


Window Panel3() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(1331,126,1446,207)
	SetVariable NoS,pos={17,8},size={84,16},title="Spot Nr.",value= _NUM:1
	SetVariable LoS,pos={17,28},size={84,16},title="Lr of spot",value= _NUM:1
	Button LocBox,pos={14,48},size={87,29},proc=AddLocNote,title="Add notation "
EndMacro


Function AddLocNote(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			Controlinfo NoS
			variable No=V_Value
			Controlinfo LoS
			variable Lr=V_Value
			
			string textname="text"+num2str(No)
			
			string cmd
			sprintf cmd, "\Z12\\f01\\K(0,65280,0)%g\\B(%g)", No,Lr
			TextBox/F=0/B=1/C/N=$textName cmd
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End


Function/wave AvgFrame3D(StartX, EndX,w,Name)
	
	VARIABLE StartX, EndX
	wave w
	STRING Name
				


	VARIABLE j

	
	make/O/n=(DimSize(w,0),DimSize(w,1)) AvgFrm
	
	For (j=StartX; j<=EndX; j+=1)
	
		Duplicate/R=[][][j,j]/O w, Image 
       	Redimension/N=(-1,-1,0) Image	
       	AvgFrm = AvgFrm + Image       			
       Endfor
       
       	AvgFrm=AvgFrm/(EndX-StartX+1)
       	killwaves/Z Image
       	rename AvgFrm, $Name
       	wave w=$Name
//       	rename AvgFrm,  $AvgName
       	Return w

End

function Sep3D(w3D)
	wave w3D
	variable i
	string ImageName
	
	for(i=0;i<DimSize(w3D,2);i+=1)
		NewImage w3D
		ModifyImage $NameOfWave(w3D),ctab= {750,1100,YellowHot,0},plane=i
		ModifyGraph noLabel(top)=2,axThick(top)=0
		ModifyGraph noLabel=2,axThick=0
		ModifyGraph margin=1
		if(i<10)
			ImageName = "Image_0"+num2str(i)+".png"
		else
			ImageName = "Image_"+num2str(i)+".png"
		endif
		SavePICT/P=home/E=-5/B=576 as ImageName 
		DoWindow/K	$winname(0,1)	
	endfor
end

function Compare2Waves(w1,w2,Th)
	wave w1,w2
	variable Th
	
	wave Vr_New,Vr_Old
	variable i,j=0
	variable diff
	for(i=0;i<DimSize(w1,0);i+=1)
		diff= abs(w1[i]-w2[i])
		if(diff>Th && w1[i]!=0 && w2[i]!=0)
			printf "%d,  %g    ", i, diff
			printf "%g,  %g\r", w1[i], w2[i]
			j=j+1
		endif
		
	endfor
	print j

end

Function/S ListFolders(str)
	string str

	STRING folderlist=""	
	STRING FolderDir=DataFolderDir(1)
	variable i
	
	For(i=0;i<ItemsInList(FolderDir,",");i+=1)
		FolderList= FolderList+";"+stringfromlist(i,FolderDir,",")
	endfor
	
	FolderList=Replacestring(";FOLDERS:", FolderList,"")
	
	string CorFolderList=""
	
	For(i=0;i<strlen(FolderList)-2;i+=1)
		CorFolderList=CorFolderList+FolderList[i]
	endfor
	
	string removedstring
	
	For(i=0;i<ItemsInList(CorFolderList);i+=1)
		if(stringmatch(stringfromlist(i,CorFolderList),str)!=1)
			removedstring = stringfromlist(i,CorFolderList)
			CorFolderList=removefromlist(removedstring,CorFolderList)
			i=i-1
		endif
	endfor	
		
	return CorFolderlist
end
