#pragma rtGlobals=1		// Use modern global access method.

Menu "Neuroplex"
"IPTK"
"Load TIFF Images from Neuroplex"
"Load Neo Images"
"Quick load resting images"
"save a image as jpeg"
"--"
"Separate images by Z"
"Separate images by Z_No stimulation"
"--"
"Make images stack"
"Default image output"
"Current trace output"
end

proc saveaimageasjpeg(No)
	variable No	
	ImageSave/D=40/T="JPEG"/Q=1.00 $stringfromlist(No,wavelist("avg*",";","")) as stringfromlist(No,wavelist("avg*",";",""))
end

Proc LoadTIFFImagesfromNeuroplex(FolderName)
        STRING FolderName
        Prompt FolderName, "enter the loaded folder name"
        Newdatafolder/S/O Working_Folder
	  LoadFileWO(FolderName)
        DFSubtract()
End

proc Quickloadrestingimages(FolderName)
	 STRING FolderName
        Prompt FolderName, "enter the loaded folder name"
	  quickload(foldername)
	  DFSubtract()
	  FileDivND(10,0)
end



Proc SeparateimagesbyZ(N1,N4,N2,N3)
	Variable N4=9,N1=8,N2=3,N3
	Prompt N1, "frame numbers per section"
	Prompt N4, "The 1st depolarization frame"
	Prompt N2, "frame numbers of depolarization"
	Prompt N3, "Data Type", popup,"Z Scan; Time Scan"
	Filedivider(N1,N4,N2,N3-1)
End

Proc SeparateimagesbyZ_NoStimulation(N1,N3)
	Variable N1=8,N2=3,N3
	Prompt N1, "frame numbers per section"
	Prompt N3, "Data Type", popup,"Z Scan; Time Scan"
	FiledivND(N1,N3-1)
End

Proc makeimagesstack(keyword)
	STRING Keyword
	Prompt keyword,"The indexed words of waves"
	ThreeDStack(keyword)
end

proc DefaultImageOutput()
	ImageOutput()
end

Proc CurrentTraceOutput(key)
	STRING Key
	prompt key,"Enter the keyword for the specified trace"
	traceoutput(key)	
end

function quickload(foldername)
	string FolderName
	
	STRING/G AllName
	STRING FileName
	VARIABLE i,j
	Variable/G n
	
	String PathName="D:Data:Tzu-Lun:Imaging:CurrentExp:"
	NewDataFolder/O/S $FolderName
	NewPath CurrentFolder, pathname
	Allname=IndexedFile(CurrentFolder,-1,".tif" )
	i = ItemsInList(AllName)
	
	For (j=0; j<=i-1; j+=1)
		ImageLoad/Q/P=CurrentFolder StringFromList(j, AllName)  
		
		wave M_load=$StringfromList(0,S_wavenames)
		
		If(waveexists(M_load))
				Duplicate/O M_load,$CleanupName(nameofwave(M_load),0)
				Killwaves/Z M_load
		Endif
		
		deletefile/P=currentfolder StringFromList(j, AllName) 
       Endfor
	// click code here
	string BNCpath="C:Documents and Settings:Administrator:Desktop"
	Newpath BNCFolder, BNCPath
	LoadWave/A/G/P=BNCFolder "BNC.txt"
	if(NVAR_Exists(n)==0)
		Variable/G n
		n=1
	else
		n=n+1
	endif
	
	String DepName="Depolarization_"+num2str(n)
	String ZName="ZStep_"+num2str(n)
	
//	Rename wave0, $DepName
//	Rename Wave1, $ZName	
	
end

function RbAvgRest()

	string F=ListFolder()
	string AN
	DFREF mDF=GetDatafolderDFR()
	
	variable i
	for(i=0;i<ItemsInList(F);i+=1)
		setdatafolder :$stringfromlist(i,F)
		AN="AvgRest"+num2str(i)
		killwaves $AN		
		AvgFrame(1,9,"slice*",AN)
		setdatafolder mDF
	endfor

end



 

