#pragma rtGlobals=1		// Use modern global access method.
#pragma rtGlobals=1		// Use modern global access method..
#include  <All IP Procedures>
#include  <Image Saver>
#include <FilterDialog> menus=0
#include  <Median XY Smoothing Dialog>
#include  <Wave Arithmetic Panel>
#include <Function Grapher>

//V3.2 is designed for NeuroPlex
//V3.3 When loading the BNC.txt, the name is automatically assigned


Window IPTK() : Panel
	PauseUpdate; Silent 1		// building window...
	STRING/G sval,FolderName,Foreground,background,ROIMaskName,ROIMask
	VARIABLE/G From,To,F_int
	NewPanel /W=(1020,57,1523,586) as "Imaging"
	ModifyPanel cbRGB=(0,0,0), frameStyle=1
	SetDrawLayer UserBack
	SetDrawEnv fillfgc= (56576,56576,56576)
	SetDrawEnv save
	SetDrawEnv fillfgc= (40960,65280,16384)
	DrawRect 27,163,245,316
	SetDrawEnv fillfgc= (0,0,0)
	SetDrawEnv save
	SetDrawEnv fillfgc= (16384,48896,65280)
	DrawRect 28,321,245,399
	SetDrawEnv fillfgc= (65280,0,52224)
	DrawRect 252,163,486,401
	SetDrawEnv fillfgc= (65280,32768,58880)
	DrawRect 255,225,481,278
	SetDrawEnv fillfgc= (52224,34816,0)
	DrawRect 27,9,485,158
	SetDrawEnv fillpat= 0
	DrawRect 239,156,33,87
	SetDrawEnv fillfgc= (52224,52224,0)
	DrawRect 252,404,486,518
	SetDrawEnv fillpat= 0
	DrawRect 33,15,239,83
	SetDrawEnv fillfgc= (51456,44032,58880)
	DrawRect 255,283,482,339
	Button button0,pos={35,17},size={203,42},proc=LoadFile,title="Load your TIFF files in"
	Button button0,fSize=14,fStyle=1
	Button button1,pos={251,40},size={223,42},proc=ButtonProc,title="Dark Frame Subtraction (NeuroPlex)"
	Button button1,fStyle=1
	Button button2,pos={257,194},size={225,28},proc=ButtonProc_1,title="2D Gaussian Fit (based on ROI)"
	Button button2,fStyle=1
	Button button3,pos={34,366},size={209,30},proc=ButtonProc_2,title="S/N Calculation"
	Button button3,fStyle=1
	SetVariable setvar0,pos={32,167},size={210,18},proc=SetVarProc,title="ROI Mask Name"
	SetVariable setvar0,fSize=12,fStyle=1,limits={-inf,inf,0},value= ROIMaskName
	Button CreateROI,pos={30,291},size={212,19},proc=CreateROI,title="Create ROI"
	Button CreateROI,fSize=14,fStyle=1
	Button StartROI,pos={30,226},size={212,20},proc=ROIFUNC,title="Start to Draw"
	Button StartROI,fSize=14,fStyle=1
	SetVariable setvar1,pos={34,326},size={212,18},proc=SetVarProc_1,title="Foreground Mask"
	SetVariable setvar1,fStyle=1,value= Foreground
	SetVariable setvar2,pos={34,345},size={212,18},proc=SetVarProc_2,title="Background Mask"
	SetVariable setvar2,fStyle=1,value= Background
	Button ClearROI,pos={30,269},size={212,20},proc=ROIFUNC,title="Erase ROI"
	Button ClearROI,fSize=14,fStyle=1
	Button button7,pos={257,248},size={223,28},proc=ImageFFT,title="FFT (based on ROI)"
	Button button7,fSize=12,fStyle=1
	SetVariable ROIName3,pos={258,168},size={224,18},proc=SpecifyROI,title="ROI Mask Name"
	SetVariable ROIName3,fSize=12,fStyle=1,value= ROIMask
	SetVariable setvar3,pos={258,229},size={219,18},proc=FrameInt,title="Frame Interval"
	SetVariable setvar3,fStyle=1,value= F_int
	Button button8,pos={29,405},size={84,22},proc=KillWave,title="KillWaves/A"
	Button button9,pos={116,405},size={112,22},proc=YellowHotModification,title="Yellow-Hot Graph"
	Button FinishROI,pos={30,248},size={212,20},proc=ROIFUNC,title="FinishROI"
	Button FinishROI,fSize=14,fStyle=1
	Button button4,pos={256,305},size={225,31},proc=Plot_SROI,title="Plot ROI (Foreground)"
	Button button4,fStyle=1
	SetVariable NewFolderName,pos={38,61},size={200,18},proc=FileFolderName,title="Folder"
	SetVariable NewFolderName,fStyle=1,limits={-inf,inf,0},value= FolderName,live= 1
	Button MoveFileTo,pos={252,16},size={221,21},proc=MoveFilesTo,title="Move the TIF files to new folder"
	Button MoveFileTo,fStyle=1
	Button FrameAverage,pos={39,110},size={195,22},proc=ButtonProc_3,title="Average Frames"
	Button FrameAverage,fStyle=1
	SetVariable StartFrameNumber,pos={43,90},size={76,18},proc=SetVarProc_4,title="From"
	SetVariable StartFrameNumber,fStyle=1,limits={-inf,inf,0},value= From
	SetVariable StopFrameNo,pos={125,90},size={60,18},proc=SetVarProc_5,title="To"
	SetVariable StopFrameNo,fStyle=1,limits={-inf,inf,0},value= To,live= 1
	Button DeltaF,pos={39,134},size={195,20},proc=FminusF0,title="F-F0",fStyle=1
	Button New_Path,pos={30,431},size={65,23},proc=New_Path,title="New Path"
	Button New_Path,fStyle=0
	Button ToDelta,pos={98,431},size={79,23},proc=GoToDelta,title="Go To DeltaF"
	Button GoToFolderAna,pos={375,497},size={109,19},proc=GoToAnalyzed,title="Go To Analyzed"
	Button GoToFolderAna,fStyle=1
	Button MoveWaveTo,pos={257,425},size={225,21},proc=MoveWaveTo,title="Move Wave To \"Analyzed\""
	Button MoveWaveTo,fStyle=1
	SetVariable NewWaveName,pos={260,407},size={220,18},proc=RenameWave,title="Rename The Wave"
	SetVariable NewWaveName,limits={-inf,inf,0},value= sval
	SetVariable WaveKeyword,pos={258,445},size={225,18},proc=WaveKey,title="Enter The Keyword of the Wave"
	SetVariable WaveKeyword,limits={-inf,inf,0},value= sval
	Button Combine,pos={256,464},size={164,30},proc=CombineWave,title="Combine waves together !! \r (Use wave keyword)"
	Button Combine,fStyle=1
	Button Displayandappened,pos={423,464},size={59,30},proc=DispAndAppend,title="Display & \r Append"
	SetVariable FolderJump,pos={282,86},size={172,18},proc=FolderJump,title="Jump To Folder"
	SetVariable FolderJump,fStyle=1
	SetVariable FolderJump,limits={-inf,inf,0},value= sval
	SetVariable SamepleInterval,pos={258,285},size={222,18},proc=FrameInt,title="Frame Interval (s)"
	SetVariable SamepleInterval,fStyle=1,value=F_int
	CheckBox ROITyep,pos={32,192},size={180,30},proc=CheckProc,title="ROI just for 2D Gaussian \rnot for BG subtract or ROI plot"
	CheckBox ROITyep,value= 0
	Button BGSubROI,pos={257,357},size={225,26},proc=BGmin,title="Substract the background by ROI"
	Button BGSubROI,fStyle=1
	ToolsGrid gridx=(255,72,8),gridy=(283,72,8)
EndMacro

Function LoadFileWO(FolderName)
       
       STRING FolderName
	STRING/G AllName
	STRING FileName
	VARIABLE i,j
	VARIABLE/G n
	
	NewDataFolder/O/S $FolderName
	NewPath CurrentFolder
	Allname=IndexedFile(CurrentFolder,-1,".tif" )
	i = ItemsInList(AllName)
	
	For (j=0; j<=i-1; j+=1)
		ImageLoad/Q/P=CurrentFolder StringFromList(j, AllName)  
		
		wave M_load=$StringfromList(0,S_wavenames)
		
		If(waveexists(M_load))
				Duplicate/O M_load,$CleanupName(nameofwave(M_load),0)
				Killwaves/Z M_load
		Endif
		
		deletefile/P=currentfolder StringFromList(j, AllName) 
       Endfor
	// click code here
	if(NVAR_Exists(n)==0)
		Variable/G n
		n=1
	else
		n = n+1
	endif
	LoadWave/D/A=ZStep_/G/P=CurrentFolder "BNC.txt"

	String ZName="ZStep_"+num2str(n)
	
//	Rename Wave0, $ZName		
		
End


Function LoadFile(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			
	STRING/G AllName
	SVAR FolderName
	STRING FileName
	VARIABLE i,j
	NVAR n
	
	NewDataFolder/O/S $FolderName
	NewPath CurrentFolder
	Allname=IndexedFile(CurrentFolder,-1,".tif" )
	i = ItemsInList(AllName)
	
	For (j=0; j<=i-1; j+=1)
		ImageLoad/Q/P=CurrentFolder StringFromList(j, AllName)  
		
		wave M_load=$StringfromList(0,S_wavenames)
		
		If(waveexists(M_load))
				Duplicate/O M_load,$CleanupName(nameofwave(M_load),0)
				Killwaves/Z M_load
		Endif 
       Endfor
	// click code here
	LoadWave/A/G/P=CurrentFolder "BNC.txt"
	if(NVAR_Exists(n)==0)
		Variable/G n
		n=1
	else
		n=n+1
	endif
	
	String DepName="Depolarization_"+num2str(n)
	String ZName="ZStep_"+num2str(n)
	
	Rename wave0, $DepName
	Rename Wave1, $ZName	
	break
		
	
	endswitch

	return 0
End

Function ButtonProc(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			DFSubtract()
			break
	endswitch

	return 0
End


Function DFSubtract()

	STRING AllName
	STRING DarkFrame
	STRING FileName
	VARIABLE i,j
	
	Allname=WaveList("TL*",";","" )
	i = ItemsInList(AllName)
	Wave Dark=$StringFromList(i-1,AllName)
	Redimension/S Dark

	
	For (j=0; j<=i-1; j+=1) 

       	Wave Image=$StringFromList(j, AllName)
		Redimension/S Image
       	Image = Image - Dark
  
       Endfor
       	
End

Function ButtonProc_1(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			TDGauss()// click code here
			break
	endswitch

	return 0
End

///////////////////////////////////////////// ROI  Name and Draw /////////////////////////////////////////////////////////////////////////////////
Function ROIFUNC(ctrlName) : ButtonControl
	String ctrlName

	String ImGrfName= WMTopImageGraph()
	if( strlen(ImGrfName) == 0 )
		return 0
	endif
	
	DoWindow/F $ImGrfName
	if( CmpStr(ctrlName,"StartROI") == 0 )
		ShowTools/A rect
		SetDrawLayer ProgFront
		Wave w= $WMGetImageWave(ImGrfName)		// the target matrix
		String iminfo= ImageInfo(ImGrfName, NameOfWave(w), 0)
		String xax= StringByKey("XAXIS",iminfo)
		String yax= StringByKey("YAXIS",iminfo)
		SetDrawEnv linefgc= (3,52428,1),fillpat= 0,xcoord=$xax,ycoord=$yax,save
	endif
	if( CmpStr(ctrlName,"FinishROI") == 0 )
		GraphNormal
		HideTools/A
		SetDrawLayer UserFront
		DoWindow/F IPTK
	endif
	if( CmpStr(ctrlName,"clearROI") == 0 )
		GraphNormal
		SetDrawLayer/K ProgFront
		SetDrawLayer UserFront
		DoWindow/F IPTK
	endif
End

Function CheckProc(cba) : CheckBoxControl
	STRUCT WMCheckboxAction &cba

	switch( cba.eventCode )
		case 2: // mouse up
			Variable/G checked_ROItype = cba.checked
			break
	endswitch

	return 0
End


Function SetVarProc(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
			STRING/G  ROIMask= sva.sval
			break
	endswitch

	return 0
End

Function CreateROI(ba) : ButtonControl
	STRUCT WMButtonAction &ba
       STRING/G ROIMask
       VARIABLE/G checked_ROItype
	switch( ba.eventCode )
		case 2: // mouse up
		if (Waveexists($ROIMask)==1)
			killwaves $ROIMask
			if(checked_ROItype == 0)
				ImageGenerateROIMask/E=1/I=0 $WMTopImageName()
			else
				ImageGenerateROIMask/E=0/I=1 $WMTopImageName()
			endif	
			Rename M_ROIMask $ROIMask
				
		else
			if(checked_ROItype == 0)
				ImageGenerateROIMask/E=1/I=0 $WMTopImageName()
			else
				ImageGenerateROIMask/E=0/I=1 $WMTopImageName()
			endif
			Rename M_ROIMask $ROIMask
		endif
			break
	endswitch

	return 0
End

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////// SN Calculation //////////////////////////////////////////////////////////////////
Function SetVarProc_1(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			String/G Foreground = sva.sval
			break
	endswitch

	return 0
End

Function SetVarProc_2(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			String/G Background = sva.sval
			break
	endswitch

	return 0
End

Function SNCalc( ROI1, ROI2)    
    
    Wave ROI1 
    Wave ROI2
    SVAR Foreground, Background
    STRING AllName
    STRING FileName
    VARIABLE j    
    VARIABLE S_Avg, B_Avg
    
    Duplicate/O $Foreground ROI1
    Duplicate/O $Background ROI2
    
    Allname=IndexedFile(CurrentFolder,-1,".tif" )
    VARIABLE i= ItemsInList(AllName)
    Make/O/N=(ItemsInList(AllName),1) Avg_S
    Make/O/N=(ItemsInList(AllName),1) Avg_B
    Make/O/N=(ItemsInList(AllName),1) SN
    
     for(j=0;j<=i-1;j+=1)
    	 FileName = CleanupName(StringFromList(j, AllName),0)
    	 ImageStats/R=ROI1 $FileName
    	 Avg_S[j] = V_avg
    	 S_Avg=V_avg 
    	 ImageStats/R=ROI2 $FileName
    	 Avg_B[j] = V_avg
    	 B_Avg=V_avg
    	 SN[j] = abs(S_Avg/B_Avg) 
     endfor
     killwaves ROI1
     killwaves ROI2
     Display SN
end

////////////////////////////////////////////////////////// FFT on ROI ///////////////////////////////////////////////////////////////
Function ImageFFT(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	SVAR sval
	VARIABLE/G F_int
	Wave X_Wave
		
	switch( ba.eventCode )
		case 2: // mouse up
	   	STRING AllName
    		STRING FileName
    		VARIABLE j    
    
    		Allname=Wavelist("*tif",";","" )
    		VARIABLE i= ItemsInList(AllName)
    		Make/O/N=(ItemsInList(AllName)-1) Intensity
   
    
    		for(j=0;j<=i-2;j+=1)  // in some graphs, the wrong fit of gaussian would drive procedure wrong.
    			FileName = StringFromList(j, AllName)
    			Imagestats/M=1/R=$sval  $FileName 
    			Intensity[j] = V_avg
    		endfor
    		Setscale/P X,0,F_int,"" Intensity
    		FFT/OUT=3/RP=[3,i-2]/DEST=Intensity_FFT Intensity		
			// click code here
			break
	endswitch

	return 0
End

Function F_Average(From,To)
	
	VARIABLE From,To
	STRING AllName
	STRING FileName
	VARIABLE j
	Make/B/O/N=(80,80) AverageFrame

	Allname=Wavelist("*",";","" )	
	For (j=From; j<=To; j+=1) 
       	FileName = StringFromList(j,AllName)
       	Redimension/S $FileName
       	WAVE Image
       	Redimension/S AverageFrame
       	Duplicate/O $FileName, Image
       	Redimension/S Image
       	AverageFrame = (AverageFrame + Image)
       Endfor
       	AverageFrame=AverageFrame/(To-From+1)
       	Killwaves Image
End

Function TDGauss()
    
    STRING AllName
    STRING FileName
    SVAR ROIMaskName
    VARIABLE j    
    
    Allname=IndexedFile(CurrentFolder,-1,".tif" )
    VARIABLE i= ItemsInList(AllName)
    Make/O/N=(ItemsInList(AllName)-1,2) Gaussian2D_Position
   
    
    for(j=0;j<=i;j+=1)  // in some graphs, the wrong fit of gaussian would drive procedure wrong.
    	FileName = CleanupName(StringFromList(j, AllName),0)
    	CurveFit/M=2/W=0 Gauss2D, $WMTopimageName() /D/M=$ROIMaskName
    	Wave W_Coef
    	Gaussian2D_Position[j][0] = W_Coef[2]
    	Gaussian2D_Position[j][1] = W_Coef[4]
    endfor
    
End

Function ButtonProc_2(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
		SNCalc( ROI1, ROI2)
			// click code here
			break
	endswitch

	return 0
End

Function SpecifyROI(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			String/G ROImaskName = sva.sval
			break
	endswitch

	return 0
End

Function FrameInt(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			Variable/G F_Int = sva.dval
			break
	endswitch

	return 0
End


Function KillWave(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			Killwaves/A// click code here
			break
	endswitch

	return 0
End

Function YellowHotModification(ba) : ButtonControl
	STRUCT WMButtonAction &ba
       
	switch( ba.eventCode )
		case 2: // mouse up
			wave image=$WMTopImageName() 			
			SetScale/P x 0,0.38,"um", $WMTopImageName()
			SetScale/P y 0,0.38,"um", $WMTopImageName()
			ModifyImage $WMTopImageName() ctab= {0,*,YellowHot,0}
			// click code here
			break
	endswitch

	return 0
End

Function Plot_SROI(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
		    Wave ROI1 
    		    SVAR ROIMaskName
    		    NVAR F_Int
    		    STRING AllName
    		    STRING FileName
    		    VARIABLE j
 
    
    Duplicate/O $ROIMaskName ROI1

    Allname=Wavelist("*tif",";","")
    VARIABLE i= ItemsInList(AllName)
    Make/O/N=(ItemsInList(AllName)) Avg_S
    Make/O/N=(ItemsInList(AllName)) Max_S
    Make/O/N=(ItemsInList(AllName)) $ROIMaskName+"Avg"
    Make/O/N=(ItemsInList(AllName)) $ROIMaskName+"Max"
    
     for(j=0;j<=i-2;j+=1)
    	 FileName = StringFromList(j, AllName)
    	 ImageStats/R=ROI1 $FileName
    	 Avg_S[j] = V_avg
    	 Max_S[j]= V_Max
     endfor

     // 1.setscale , one column for frame interval is needed
     SetScale/P x 0,F_Int,"s", Avg_S
     SetScale/P x 0,F_Int,"s", Max_S
          
     Duplicate Avg_S, $ROIMaskName+"Avg"
     Duplicate Max_S, $ROIMaskName+"Max"
     // 2.on checkbox for filtering is also needed, perhaps a special box for filtering.
			
			display $ROIMaskName+"Avg"
			Killwaves ROI1, Avg_S, Max_S
			// click code here
			break
	endswitch

	return 0
End

Function FileFolderName(FolderName) : SetVariableControl
	STRING FolderName
End

Function MoveFilesTo(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: 
		SVAR FolderName
		String/G AllName
		String CurrentFolder,NewPa
		Variable i,j
		
		Newpath/M="Select the tif folder" CurrentFolder
		AllName = indexedFile(CurrentFolder, -1, ".tif")
		i=ItemsInList(allname,";")
		Newpath/C/M="Key in the new folder name directly" NewFolder
		Pathinfo NewFolder
		NewPa=S_Path
		
		For (j=0; j<=i-1; j+=1)
			movefile/D/P=CurrentFolder StringFromList(j,allname) as NewPa
       	Endfor
		
			break
	endswitch

	return 0
End

Function ButtonProc_3(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			STRING CurrentFolder=GetDataFolder(1)
			SetDataFolder Root:
			NVAR From,To
			SetDataFolder $CurrentFolder
			F_Average(From,To)
			// click code here
			break
	endswitch

	return 0
End

Function SetVarProc_4(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			STRING CurrentFolder=GetDataFolder(1)
			SetDataFolder Root:
			Variable/G From = sva.dval
			SetDataFolder $CurrentFolder 		   
			Break
	endswitch

	return 0
End

Function SetVarProc_5(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			STRING CurrentFolder=GetDataFolder(1)
			SetDataFolder Root:
			Variable/G To = sva.dval
			SetDataFolder $CurrentFolder
			Break
	endswitch

	return 0
End

Function FminusF0(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
		STRING AllName
		STRING FileName
		
		VARIABLE i,j
		Wave AverageFrame
		
		Allname=WaveList("*",";","" )
		i = ItemsInList(AllName)
		NewDataFolder DeltaF
		
		For (j=0; j<=i-2; j+=1)
		Make/O/N=(80,80) Image 
       	FileName = StringFromList(j, AllName)
       	Duplicate/O $FileName, Image
       	Redimension/S Image
       	Redimension/S AverageFrame
       	Image = Image - AverageFrame
       	String CurrentFolder=GetDataFolder(1)
       	SetDataFolder DeltaF
		MoveWave Image,$FileName
		SetDataFolder $CurrentFolder
       Endfor
       	Killwaves Image

			// click code here
			break
	endswitch

	return 0
End

Function New_Path(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			NewPath CurrentFolder
			// click code here
			break
	endswitch

	return 0
End

Function GoToDelta(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			SetDataFolder DeltaF// click code here
			break
	endswitch

	return 0
End





Function GoToAnalyzed(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			SetDataFolder Root:
			if (	DataFolderExists("ANALYZED") == 0	)
				NewDataFolder ANALYZED
				Setdatafolder ANALYZED
			else
				SetDataFolder Analyzed
			endif
			// click code here
			break
	endswitch

	return 0
End

Function MoveWaveTo(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			SVAR NewName
			movewave $NewName, Root:Analyzed:
			Killstrings NewName
			// click code here
			break
	endswitch

	return 0
End

Function RenameWave(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			WAVE CurrentWave = WaveRefIndexed("",0,1)
			STRING/G NewName = sva.sval
			Make $NewName
			Duplicate/O CurrentWave, $NewName
			break
	endswitch

	return 0
End

Function WaveKey(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			STRING/G WaveKeyword = sva.sval
			break
	endswitch

	return 0
End

Function CombineWave(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			SVAR WaveKeyword
			STRING AllName=WaveList("*",";","")
			VARIABLE i,j
			i = ItemsInList(Allname,";")
			
			for(j=0;j<=i-1;j+=1)
			Concatenate {$StringFromList(j,Allname)}, TempWave
			endfor
			Duplicate/O TempWave, $Wavekeyword
			Killwaves TempWave
			NewDataFolder $Wavekeyword
			SetDataFolder $WaveKeyword
			STRING CurrentFolder =GetDataFolder(1)
			SetDataFolder Root:ANALYZED:
			for(j=0;j<=i-1;j+=1)
				MoveWave $StringFromList(j,Allname), $CurrentFolder
			endfor
			MoveWave $WaveKeyWord, $CurrentFolder
			// click code here
			break
	endswitch

	return 0
End

Function DispAndAppend(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			Duplicate/O $GetDataFolder(0),TempWave
			STRING AllName=WaveList("*",";","")
			NVAR F_int
			VARIABLE i,j
			i = ItemsInList(Allname,";")
                   SetScale/P x 0,F_int,"s", TempWave
			Display TempWave[][0]
			for(j=1;j<=i-3;j+=1)
				AppendToGraph TempWave[][j]
			endfor

			// click code here
			break
	endswitch

	return 0
End


Function FolderJump(sva) : SetVariableControl
	STRUCT WMSetVariableAction &sva

	switch( sva.eventCode )
		case 1: // mouse up
		case 2: // Enter key
		case 3: // Live update
			STRING FolderName = sva.sval
			setdatafolder Root:
			SetDataFolder $FolderName			
			break
	endswitch

	return 0
End





Function BGmin(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	STRING/G ROIMask
	switch( ba.eventCode )
		case 2: // mouse up
			ImageStats/R=$ROIMask $WMTopImageName()
			Redimension/S $WMTopImageName()
			Wave Image
			Duplicate/O $WMTopImageName() Image
			Image = Image - V_avg
			// click code here
			break
	endswitch

	return 0
End
