#pragma rtGlobals=1		// Use modern global access method.
#include  <All IP Procedures>
#include  <Image Saver>
// 
//Update Notification:
//  V5  Change the protocol to find the first Z level and its depolarization
//  V5.1 NewFunction AutoRun(). It would automatically run Imageoutput() and ThreeDstack() together.
//  V7  NewFunction Z construction without depolarization FileDivND(N1,N2). This function also embeded in "Neuroplex" 
 
Function FileDivider(N_Frames,N_DepOnset,N_DepFrame,T_index)  //N_Frames: Number of frames per section ; N_DepFrame: Number of frames at depolarization
	VARIABLE N_Frames, N_DepFrame,T_index,N_DepOnset        // T_index: Data type, 0 = step scan, 1 = IV scan
	Print "Specify your working folder at first"
	
	Variable i,j,m,n,r1,p,S
	Variable num1,num2
	String allwave=Wavelist("TL*",";","")
	String ZName = "Z"
	String DepName = "Dep"
	String NewWaveName = "Slice"
	String FolderName = GetDataFolder(1)
	
//////////////////////////////////// RENAME THE WAVES AS A STANDARD ORDER ///////////////////////////////////////////
	
	n=ItemsInList(allwave,";")
	for(i=0;i<=n-2;i+=1)
		Rename $Stringfromlist(i,allwave,";") $NewWaveName+num2str(i)
	Endfor
	
/////////////////////////////////// DIVIDE THE FILES TO DIFFERENT SLICES //////////////////////////////////////////////////////
	
	Wave/Z Depolarization
	Wave/Z ZStep
	VARIABLE/G K
	VARIABLE tempK  
	
	if(T_index == 0)
		Duplicate/O ZStep, IndexWave
		if(K == 0)
			tempK=0
		else
			tempK=K
		endif
		S=1
		// Identify the 1st section
		for(i=0;i<=5*N_Frames;i+=1)
			num1=IndexWave[i]
			num2=IndexWave[i+1]
		
			if(abs(num2-num1)>30)
				r1=i
				NewDataFolder/O $NewWaveName+num2str(k)
				for(m=0;m<=r1-1; m+=S)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[0,m-1] ZStep, $ZNAME+num2str(k)
				Duplicate/R=[0,m-1] Depolarization, $DepName+num2str(k)
				movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):	
				break
			endif
		endfor
	//
	
		for(i=r1;i<=n;i+=N_Frames)									
		
			allwave=wavelist("Slice*",";","")
		
			if ( itemsinlist(allwave,";") > N_frames )
				K=K+S
				NewDataFolder $NewWaveName+num2str(k)
			else
				Killwaves/A
				break
			endif
		
			for(m=i;m<=i+N_Frames; m+=1)
				movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
			endfor		
		 
			Duplicate/R=[i+1,m] ZStep, $ZNAME+num2str(k)
			Duplicate/R=[i+1,m] Depolarization, $DepName+num2str(k)
			movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
			movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):					
		
		
		endfor
	else
		DFREF cDFR=GetDataFolderDFR()
		SetDataFolder PM
		String PDepImon=Wavelist("PDep*1",";","")
		String PDepVmon=Wavelist("PDep*2",";","")
		String PDepLeak=Wavelist("PDep*3",";","")
             SetDataFolder cDFR
             TempK=-70
             K = -70
		S = 10

		for(i=0;i<n-1;i+=N_Frames)
				NewDataFolder/O $NewWaveName+num2str(k)
				for(m=i;m<i+N_Frames; m+=1)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[i,m-1] Depolarization, $DepName+num2str(k)
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepImon,";"), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepVmon,";"), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepLeak,";"), :$NewWaveName+num2str(k):
				K=K+S	
		endfor
		
	endif
	


	

	
//////////////////////////////// IDENTIFYING DEPLOLARIZING FROM RESTING ///////////////////////////////////////////////////
	
	for(i=tempK;i<k;i+=S)
		SetDataFolder $FolderName
		SetDataFolder :$NewWaveName+num2str(i)
		
		STRING CurrentWaves= Wavelist("Slice*",";","")
		VARIABLE OnsetTiming=N_DepOnset 


			wave w1=AvgFrame(1,OnsetTiming-2,"slice*","AvgRest")
			
			//create and move deltaF
//			for(j=0;j<N_Frames;j+=1)
//				MAKE/O/N=(80,80) TempWave
//				Duplicate/O $StringFromList(j,CurrentWaves), TempWave
//				Redimension/S TempWave
//				TempWave= TempWave - AvgRest
//				NewDataFolder/S DeltaF
//				Movewave TempWave, $StringFromList(j,CurrentWaves)
//				SetDataFolder $FolderName
//				SetDataFolder $NewWaveName+num2str(i)
//			endfor


			wave w2=AvgFrame(OnsetTiming+1,OnsetTiming+N_DepFrame-1,"slice*","AvgDep")						
			
			String Name
			
			make/O/n=(DimSize(AvgRest,0),DimSize(AvgRest,1)) dAvgDep
			dAvgDep = w2 - w1
			
			Name = "AvgRest"
			Rename AvgRest, $Name+Num2str(i)
			Name = "AvgDep"
			Rename AvgDep, $Name+num2str(i)
			Name = "dAvgDep"
			Rename dAvgDep, $Name+num2str(i)
			
	Endfor
				
// Executing Autorun() inside
 				
End

Function FileDividerJump(N_Frames,T_index)  //N_Frames: Number of frames per section ; N_DepFrame: Number of frames at depolarization
	VARIABLE N_Frames,T_index       // T_index: Data type, 0 = step scan, 1 = IV scan
	Print "Specify your working folder at first"
	
	Variable i,j,m,n,r1,p,S
	Variable num1,num2
	variable layNr,layOrIndex
	String allwave=Wavelist("TL*",";","")
	String ZName = "Z"
	String DepName = "Dep"
	String NewWaveName = "Slice"
	
	String FolderName = GetDataFolder(1)
	
//////////////////////////////////// RENAME THE WAVES AS A STANDARD ORDER ///////////////////////////////////////////
	
	n=ItemsInList(allwave,";")
	layNr=(n-1)/N_Frames
	layOrIndex=ceil(LayNr)	
		
	for(i=0;i<n-1;i+=1)			
		Rename $Stringfromlist(i,allwave,";") $NewWaveName+num2str(i)		
	Endfor
	
	String PDepImon=Wavelist("PDep*_1",";","")
	String PDepVmon=Wavelist("PDep*_2",";","")
	String PDepLeak=Wavelist("PDep*_5",";","")
	
/////////////////////////////////// DIVIDE THE FILES TO DIFFERENT SLICES //////////////////////////////////////////////////////
	
	Wave Depolarization
	Wave/Z ZStep
	variable tempK
	NVAR/Z K  
	
	if(T_index == 0)
		Duplicate/O ZStep, IndexWave
		if(NVAR_Exists(K)==1)
			NVAR K
			tempK=K
		else
			Variable/G K=-1
			tempK=0
		endif
		S=1
		// Identify the 1st section
		j=-2
		for(i=0;i<n-1;i+=2*N_frames)
			j=j+2
			allwave=wavelist("Slice*",";","")
			
			if ( itemsinlist(allwave,";") > N_frames )
				K=K+S
				NewDataFolder $NewWaveName+num2str(k)
			else
				K=K+S
				Killwaves/A
				break
			endif
			
			for(m=i;m<i+N_Frames; m+=1)
				movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
			endfor
			Duplicate/R=[i,m-1] ZStep, $ZNAME+num2str(k)
			Duplicate/R=[i,m-1] Depolarization, $DepName+num2str(k)
			movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
			movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(j,PDepImon,";"), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(j,PDepVmon,";"), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(j,PDepLeak,";"), :$NewWaveName+num2str(k):
	
		endfor
		
		if(mod(LayOrIndex,2)!=0)
			j=j+1
			for(i=(LayNr-2)*N_Frames;i>0;i=i-2*N_frames)
				j=j-2
				k=k+s
				NewDataFolder $NewWaveName+num2str(k)
				for(m=i;m<i+N_Frames; m+=1)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[i+1,m] ZStep, $ZNAME+num2str(k)
				Duplicate/R=[i+1,m] Depolarization, $DepName+num2str(k)
				movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepImon,";"), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepVmon,";"), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepLeak,";"), :$NewWaveName+num2str(k):
			endfor				
		else
			j=j+3
			for(i=(LayNr-1)*N_Frames;i>0;i=i-2*N_frames)
				j=j-2
				k=k+s
				NewDataFolder $NewWaveName+num2str(k)
				for(m=i;m<i+N_Frames; m+=1)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[i+1,m] ZStep, $ZNAME+num2str(k)
				Duplicate/R=[i+1,m] Depolarization, $DepName+num2str(k)
				movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepImon,";"), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepVmon,";"), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepLeak,";"), :$NewWaveName+num2str(k):
			endfor
			
		endif
	//
	else
		DFREF cDFR=GetDataFolderDFR()
		SetDataFolder PM
//		String PDepImon=Wavelist("PDep*1",";","")
//		String PDepVmon=Wavelist("PDep*2",";","")
//		String PDepLeak=Wavelist("PDep*3",";","")
             SetDataFolder cDFR
             tempK = -70
	     	k=tempK
	     	S = 10

		for(i=0;i<n-1;i+=N_Frames)
				NewDataFolder/O $NewWaveName+num2str(k)
				for(m=i;m<i+N_Frames; m+=1)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[i,m-1] Depolarization, $DepName+num2str(k)
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepImon,";"), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepVmon,";"), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepLeak,";"), :$NewWaveName+num2str(k):
				K=K+S	
		endfor
		
	endif
		
//////////////////////////////// IDENTIFYING DEPLOLARIZING FROM RESTING ///////////////////////////////////////////////////
	
	for(i=tempK;i<=k;i+=S)
		SetDataFolder $FolderName
		SetDataFolder :$NewWaveName+num2str(i)
		
		STRING CurrentWaves= Wavelist("Slice*",";","")


			wave w2=AvgFrame(1,8,"slice*","AvgRest")
			
			//create and move deltaF
//			for(j=0;j<N_Frames;j+=1)
//				MAKE/O/N=(80,80) TempWave
//				Duplicate/O $StringFromList(j,CurrentWaves), TempWave
//				Redimension/S TempWave
//				TempWave= TempWave - AvgRest
//				NewDataFolder/S DeltaF
//				Movewave TempWave, $StringFromList(j,CurrentWaves)
//				SetDataFolder $FolderName
//				SetDataFolder $NewWaveName+num2str(i)
//			endfor


			wave w1=AvgFrame(21,26,"slice*","AvgDep")						
			
			String Name
			
			make/O/n=(DimSize(AvgRest,0),DimSize(AvgRest,1)) dAvgDep
			dAvgDep = w1 - w2
			
			Name = "AvgRest"
			Rename AvgRest, $Name+Num2str(i)
			Name = "AvgDep"
			Rename AvgDep, $Name+num2str(i)
			Name = "dAvgDep"
			Rename dAvgDep, $Name+num2str(i)
			
	Endfor
				
// Executing Autorun() inside
 	
End

Function FileDividerJumpF(N_Frames,T_index)  //N_Frames: Number of frames per section ; N_DepFrame: Number of frames at depolarization
	VARIABLE N_Frames,T_index        // T_index: Data type, 0 = step scan, 1 = IV scan
	Print "Specify your working folder at first"
	
	Variable i,j,m,n,r1,p,S
	Variable num1,num2
	variable layNr,layOrIndex
	String allwave=Wavelist("TL*",";","")
	String ZName = "Z"
	String DepName = "Dep"
	String NewWaveName = "Slice"
	
	String FolderName = GetDataFolder(1)
	
//////////////////////////////////// RENAME THE WAVES AS A STANDARD ORDER ///////////////////////////////////////////
	
	n=ItemsInList(allwave,";")
	layNr=(n-1)/N_Frames
	layOrIndex=ceil(LayNr)	
		
	for(i=0;i<n-1;i+=1)	
//		matrixfilter/n=3/p=1 gauss $Stringfromlist(i,allwave,";")		
		Rename $Stringfromlist(i,allwave,";") $NewWaveName+num2str(i)		
	Endfor
	
	String PDepImon=Wavelist("PDep*1",";","")
	String PDepVmon=Wavelist("PDep*2",";","")
	String PDepLeak=Wavelist("PDep*3",";","")
	
/////////////////////////////////// DIVIDE THE FILES TO DIFFERENT SLICES //////////////////////////////////////////////////////
	
	string BNCWaves=wavelist("*",";","DIMS:1")
	rename $stringfromlist(0,BNCWaves), Depolarization
	rename $stringfromlist(1,BNCWaves), ZStep
	rename $stringfromlist(2,BNCWaves), ICa
	variable tempK
	NVAR/Z K  
	
	if(T_index == 0)

		if(NVAR_Exists(K)==1)
			NVAR K
			tempK=K
		else
			Variable/G K=-1
			tempK=0
		endif
		S=1
		// Identify the 1st section
		j=-2
		for(i=0;i<n-1;i+=2*N_frames)
			j=j+2
			allwave=wavelist("Slice*",";","")
			
			if ( itemsinlist(allwave,";") > N_frames )
				K=K+S
				NewDataFolder $NewWaveName+num2str(k)
			else
				K=K+S
				Killwaves/A
				break
			endif
			
			for(m=i;m<i+N_Frames; m+=1)
				movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
			endfor
			Duplicate/R=[i+1,m] ZStep, $ZNAME+num2str(k)
			Duplicate/R=[i+1,m] Depolarization, $DepName+num2str(k)
			movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
			movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(j,PDepImon,";"), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(j,PDepVmon,";"), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(j,PDepLeak,";"), :$NewWaveName+num2str(k):
	
		endfor
		
		if(mod(LayOrIndex,2)!=0)
			j=j+1
			for(i=(LayNr-2)*N_Frames;i>0;i=i-2*N_frames)
				j=j-2
				k=k+s
				NewDataFolder $NewWaveName+num2str(k)
				for(m=i;m<i+N_Frames; m+=1)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[i+1,m] ZStep, $ZNAME+num2str(k)
				Duplicate/R=[i+1,m] Depolarization, $DepName+num2str(k)
				movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepImon,";"), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepVmon,";"), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepLeak,";"), :$NewWaveName+num2str(k):
			endfor				
		else
			j=j+3
			for(i=(LayNr-1)*N_Frames;i>0;i=i-2*N_frames)
				j=j-2
				k=k+s
				NewDataFolder $NewWaveName+num2str(k)
				for(m=i;m<i+N_Frames; m+=1)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[i+1,m] ZStep, $ZNAME+num2str(k)
				Duplicate/R=[i+1,m] Depolarization, $DepName+num2str(k)
				movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepImon,";"), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepVmon,";"), :$NewWaveName+num2str(k):
				movewave $Stringfromlist(j,PDepLeak,";"), :$NewWaveName+num2str(k):
			endfor
			
		endif
	//
	else
		DFREF cDFR=GetDataFolderDFR()
		SetDataFolder PM
//		String PDepImon=Wavelist("PDep*1",";","")
//		String PDepVmon=Wavelist("PDep*2",";","")
//		String PDepLeak=Wavelist("PDep*3",";","")
             SetDataFolder cDFR
             tempK = -70
	     	k=tempK
	     	S = 10

		for(i=0;i<n-1;i+=N_Frames)
				NewDataFolder/O $NewWaveName+num2str(k)
				for(m=i;m<i+N_Frames; m+=1)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[i,m-1] Depolarization, $DepName+num2str(k)
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepImon,";"), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepVmon,";"), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepLeak,";"), :$NewWaveName+num2str(k):
				K=K+S	
		endfor
		
	endif
		
//////////////////////////////// IDENTIFYING DEPLOLARIZING FROM RESTING ///////////////////////////////////////////////////
	
	for(i=tempK;i<=k;i+=S)
		SetDataFolder $FolderName
		SetDataFolder :$NewWaveName+num2str(i)
		
		STRING CurrentWaves= Wavelist("Slice*",";","")

			wave w1=AvgFrame(1,8,"slice*","AvgRest")
			
			//create and move deltaF
//			for(j=0;j<N_Frames;j+=1)
//				MAKE/O/N=(80,80) TempWave
//				Duplicate/O $StringFromList(j,CurrentWaves), TempWave
//				Redimension/S TempWave
//				TempWave= TempWave - AvgRest
//				NewDataFolder/S DeltaF
//				Movewave TempWave, $StringFromList(j,CurrentWaves)
//				SetDataFolder $FolderName
//				SetDataFolder $NewWaveName+num2str(i)
//			endfor


			wave w2=AvgFrame(21,26,"slice*","AvgDep")						
			
			String Name
			
			make/O/n=(DimSize(AvgRest,0),DimSize(AvgRest,1)) dAvgDep
			dAvgDep = w2 - w1
			
			Name = "AvgRest"
			Rename AvgRest, $Name+Num2str(i)
			Name = "AvgDep"
			Rename AvgDep, $Name+num2str(i)
			Name = "dAvgDep"
			Rename dAvgDep, $Name+num2str(i)
			
	Endfor
				
// Executing Autorun() inside
 	
End


Function TraceOutput(key)
	STRING key
	String FolderName = Datafolderdir(1)
	String CurrentFolder =GetDataFolder(1)
	String allwaves
	Variable i
	
	NewDataFolder/O PatchMaster
	for(i=0; i< ItemsInList(FolderName,",");i+=1)
		Setdatafolder $GetIndexedObjName("",4,i)
		allwaves = Wavelist(key,";","")
		Duplicate/O $stringfromlist(0,allwaves,";"), TempWave
		Setdatafolder $CurrentFolder
		Duplicate/O TempWave, :PatchMaster:$stringfromlist(0,allwaves,";")
	endfor
	
	
end

Function ImageOutput()

	String FolderName = Datafolderdir(1)
	String CurrentFolder =GetDataFolder(1)
	String allwaves
	String WaveNam = "AVGdep"
	Variable i
	
	NewDataFolder ZStack_DeltaF
	for(i=0; i<ItemsInList(FolderName,",");i+=1)
		Setdatafolder $GetIndexedObjName("",4,i)
		allwaves = Wavelist("dAVGdep*",";","")
		Duplicate/O $stringfromlist(0,allwaves,";"), TempWave
		Setdatafolder $CurrentFolder
		Duplicate/O TempWave, :Zstack_DeltaF:$stringfromlist(0,allwaves,";")
	endfor

	NewDataFolder ZStack_Raw_Dep
	for(i=0; i<ItemsInList(FolderName,",");i+=1)
		Setdatafolder $GetIndexedObjName("",4,i)
		allwaves = Wavelist("AVGdep*",";","")
		Duplicate/O $stringfromlist(0,allwaves,";"), TempWave
		Setdatafolder $CurrentFolder
		Duplicate/O TempWave, :Zstack_Raw_Dep:$stringfromlist(0,allwaves,";")
	endfor
	
	NewDataFolder ZStack_Rest
	for(i=0; i<ItemsInList(FolderName,",");i+=1)
		Setdatafolder $GetIndexedObjName("",4,i)
		allwaves = Wavelist("AVGRest*",";","")
		Duplicate/O $stringfromlist(0,allwaves,";"), TempWave
		Setdatafolder $CurrentFolder
		Duplicate/O TempWave, :Zstack_Rest:$stringfromlist(0,allwaves,";")
	endfor
end

Function ZOutput()

	String FolderName = Datafolderdir(1)
	String CurrentFolder =GetDataFolder(1)
	String allwaves
	String WaveNam = "Z"
	Variable i,n
	
	NewDataFolder Z_BNC
	for(i=0; i<ItemsInList(FolderName,",");i+=1)
		Setdatafolder $GetIndexedObjName("",4,i)
		allwaves = Wavelist("Z*",";","")
		Duplicate/O $stringfromlist(0,allwaves,";"), TempWave
		Setdatafolder $CurrentFolder
		Duplicate/O TempWave, :Z_BNC:$stringfromlist(0,allwaves,";")
	endfor
	setdatafolder Z_BNC
	allwaves=wavelist("z*",";","")
	For(i=0;i<ItemsInList(allwaves);i+=1)
		concatenate/NP {$Stringfromlist(i,allwaves,";")}, Z_BNC
	endfor

end

Function ThreeDStack(keyword)
	STRING keyword
	String AllWaveName = wavelist(keyword,";","")
	Variable i
	
	Duplicate/O $StringfromList(0,allwavename,";"),Time_Stack
	for(i=1;i<itemsinlist(AllWaveName);i+=1)
		Concatenate/NP=2/DL {$Stringfromlist(i,allwavename,";")},Time_Stack
	endfor
end

Function Plus3DStack()
	Make/O/n=8 Time_Stack
	String AllWaveName = wavelist("dAvg*",";","")
	Variable i
	
	NewDataFolder GaussBlurFiltered
	for(i=0;i<itemsinlist(AllWaveName)-2;i+=1)
		Duplicate/O $StringfromList(i,allwavename,";"), :GaussBlurFiltered:$StringfromList(i,allwavename,";")
	endfor

	SetDataFolder GaussBlurFiltered
	MatrixFilter/N=3/P=2 gauss, $StringfromList(0,allwavename,";")	
	Duplicate/O $StringfromList(0,allwavename,";"),ZStack_DF
	
	for(i=1;i<itemsinlist(AllWaveName)-2;i+=1)
		MatrixFilter/N=3/P=1 gauss, $StringfromList(i,allwavename,";")
		Concatenate/DL {$Stringfromlist(i,allwavename,";")},ZStack_DF
	endfor
end


Function AutoRun()
 
 String Folder1 = Stringfromlist(2,GetDatafolder(1),":")
 SetDataFolder Root:working_folder:$(Folder1)
 Imageoutput()
 String Folder2 = "ZStack_DeltaF"
 Setdatafolder Root:Working_folder:$(Folder1):$(Folder2)
 ThreeDStack("dAVG*")
 String Folder3 = "ZStack_Raw_Dep"
 Setdatafolder Root:Working_folder:$(Folder1):$(Folder3)
 ThreeDStack("AvgDep*")
End	


Function FileDivND(N_Frames,T_index)  //N_Frames: Number of frames per section ; N_DepFrame: Number of frames at depolarization
	VARIABLE N_Frames,T_index        // T_index: Data type, 0 = step scan, 1 = IV scan
	Print "Specify your working folder at first"
	
	DFREF home=getdatafolderdfr()
	Variable i,j,m,n,r1,l,p,S
	Variable num1,num2
	String allwave=Wavelist("TL*",";","")
	string AvgRestW
	String ZName = "Z"
	String NewWaveName = "Slice"
	String FolderName = GetDataFolder(1)
	
//////////////////////////////////// RENAME THE WAVES AS A STANDARD ORDER ///////////////////////////////////////////
	
	n=ItemsInList(allwave,";")
	for(i=0;i<n;i+=1)
		Rename $Stringfromlist(i,allwave,";") $NewWaveName+num2str(i)
	Endfor
	
/////////////////////////////////// DIVIDE THE FILES TO DIFFERENT SLICES //////////////////////////////////////////////////////
	
	Wave/Z ZStep
	VARIABLE/G K
	VARIABLE tempK 
	String Name = "AvgRest"
	
	Switch (T_index)
		Case 0:
			Duplicate/O Zstep, IndexWave 
			Break
		Case 1:
			Duplicate/O Depolarization, IndexWave
			Break
		case 2:
			Duplicate/O Zstep, IndexWave 
			break
	endswitch
	
		if(K == 0)
			tempK=0
		else
			tempK=K
		endif
		S=1

	
		for(i=0;i<=n;i+=N_Frames)									
		
		
			allwave=wavelist("Slice*",";","")
		
			if ( itemsinlist(allwave,";") >= N_frames )
				K=K+S
				NewDataFolder $NewWaveName+num2str(k-1)
			else
				Killwaves/A
				break
			endif
		
			for(m=i;m<N_Frames+i; m+=1)
				movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k-1):
			endfor		
		 
			Duplicate/R=[i,m] ZStep, $ZNAME+num2str(k-1)
			movewave $ZNAME+num2str(k-1), :$NewWaveName+num2str(k-1):
			SetDataFolder  :$NewWaveName+num2str(k-1):
			allwave = WaveList("Slice*",";","")
			l=0
			Make/O/N=(80,80) AvgRest
			for(m=0;m<ItemsInList(allwave,";"); m+=1)
				Duplicate/O $StringFromList(m,allwave), TempWave
				Redimension/S TempWave
				AvgRest = AvgRest + TempWave
				l=l+1
			Endfor
			killwaves TempWave
			AvgRest=Avgrest/l
			Name="AvgRest"+num2str(K-1)
			Rename AvgRest, $Name
			SetDataFolder home
							
		endfor
	
// 	String Folder1 = Stringfromlist(2,GetDatafolder(1),":")
 	
//	SetDataFolder Root:working_folder:$(Folder1)
	FolderName = ListFolder()
//	String CurrentFolder =GetDataFolder(1)
	
	Switch (T_index)
		Case 0:
			NewDataFolder ZStack
			Break
		Case 1:
			NewDataFolder TStack
			Break
	endswitch
		
		
	for(i=0; i<= ItemsInList(FolderName);i+=1)
		Setdatafolder $stringfromlist(i,Foldername)
		AvgRestW = Wavelist("AVGRest*",";","")
		duplicate $stringfromlist(0,AvgRestW,";"), home:$stringfromlist(0,AvgRestW,";")
		Setdatafolder home
		Switch (T_index)
			Case 0:
				movewave $stringfromlist(0,AvgRestW,";"), :Zstack:
				break
			Case 1:
				movewave $stringfromlist(0,AvgRestW,";"), :Tstack:
				break
		endswitch
	endfor

	Switch (T_index)
		Case 0:
			String Folder2 = "ZStack"
			 Setdatafolder home:$(Folder2) 
			Break
		Case 1:
 			String Folder3 = "TStack"
 			Setdatafolder home:$(Folder3)
			Break

	endSwitch

 	ThreeDStack("AVGRest*")
 	Rename Time_stack, Rest_Stack
 	Setscale/P x,0,0.164,Rest_Stack
 	Setscale/P y,0,0.164 ,Rest_Stack
 	SetDatafolder Root:

End




Function PPTDividedJump(oe)  //N_Frames: Number of frames per section ; N_DepFrame: Number of frames at depolarization
	VARIABLE oe //0:even 1:odd

	
	Variable i,j

	string AFolders=ListFolder()
	variable NoF= ItemsInList(AFolders)-1
	
//////////////////////////////////// RENAME THE WAVES AS A STANDARD ORDER ///////////////////////////////////////////
		
	String PDepImon=Wavelist("PDep*1",";","")
	String PDepVmon=Wavelist("PDep*2",";","")
	String PDepLeak=Wavelist("PDep*3",";","")
	
/////////////////////////////////// DIVIDE THE FILES TO DIFFERENT SLICES //////////////////////////////////////////////////////
	
		
		switch(oe)
			case 1:
				i=0
				for(j=0;j<NoF;j+=2)
					movewave $Stringfromlist(j,PDepImon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepVmon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepLeak,";"), :$StringFromList(i,AFolders,";"):
					i+=1
				endfor
				for(j=NoF-2;j>=0;j-=2)
					movewave $Stringfromlist(j,PDepImon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepVmon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepLeak,";"), :$StringFromList(i,AFolders,";"):
					i+=1
				endfor				
			case 0:
				i=0
				for(j=0;j<NoF;j+=2)
					movewave $Stringfromlist(j,PDepImon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepVmon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepLeak,";"), :$StringFromList(i,AFolders,";"):
					i+=1
				endfor
				for(j=NoF-1;j>=0;j-=2)
					movewave $Stringfromlist(j,PDepImon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepVmon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepLeak,";"), :$StringFromList(i,AFolders,";"):
					i+=1
				endfor	
			
		endswitch
	//
 	
End


function savemove(Exo,Sfo)
	VARIABLE Exo,Sfo
	
	string datafolder="slice"+num2str(Sfo)
	string ExpFolderOld=num2str(0)+num2str(Exo)
	string ExpFolderNew=num2str(0)+num2str(Exo)+"New"
	DFREF home=getdatafolderdfr()
	setdatafolder :$expfolderold
	setdatafolder :$datafolder
	DFREF Source=getdatafolderdfr()
	setdatafolder home
	setdatafolder :$ExpFolderNew
	setdatafolder :$datafolder
	DFREF Dest=getdatafolderdfr()
	
	setdatafolder Source
	string SpotROI=wavelist("spot*",";","")
	string AvgROI=wavelist("9_*",";","")
	variable i
	
	for(i=0;i<ItemsInList(SpotROI);i+=1)
		movewave $stringfromList(i,SpotROI),Dest
	endfor
	
	for(i=0;i<ItemsInList(AvgROI);i+=1)
		movewave $stringfromList(i,AvgROI),Dest
	endfor
	
	setdatafolder home
end



Function FDJv2(N_Frames,T_index)  //N_Frames: Number of frames per section ; N_DepFrame: Number of frames at depolarization
	VARIABLE N_Frames,T_index       // T_index: Data type, 0 = step scan, 1 = IV scan
	Print "Specify your working folder at first"
	
	Variable i,j,m,n,r1,p,S
	Variable num1,num2
	variable layNr,layOrIndex
	String allwave=Wavelist("TL*",";","")
	String ZName = "Z"
	String DepName = "Dep"
	String NewWaveName = "Slice"
	
	String FolderName = GetDataFolder(1)
	
//////////////////////////////////// RENAME THE WAVES AS A STANDARD ORDER ///////////////////////////////////////////
	
	n=ItemsInList(allwave,";")-1
	layNr=(n-1)/N_Frames
	layOrIndex=ceil(LayNr)	
		
	for(i=0;i<n;i+=1)			
		Rename $Stringfromlist(i,allwave,";") $NewWaveName+num2str(i)		
	Endfor
	
	String PDepImon=Wavelist("PDep*_1",";","")
	String PDepVmon=Wavelist("PDep*_2",";","")
	String PDepImg=Wavelist("PDep*_3",";","")
	String PDepLeak=Wavelist("PDep*_5",";","")
	
/////////////////////////////////// DIVIDE THE FILES TO DIFFERENT SLICES //////////////////////////////////////////////////////
	string BNCWaves=wavelist("*",";","DIMS:1")
	rename $stringfromlist(0,BNCWaves), Depolarization
	rename $stringfromlist(1,BNCWaves), ZStep
	rename $stringfromlist(2,BNCWaves), ICa

	variable tempK
	NVAR/Z K  
	
	if(T_index == 0)

		if(NVAR_Exists(K)==1)
			NVAR K
			tempK=K
		else
			Variable/G K=-1
			tempK=0
		endif
		S=1
		// Identify the 1st section
		j=-2
				
		for(i=(n/N_frames);i>=0;i-=2)
			if(mod(n/N_frames,2)==0 && i==(n/N_frames))
				i=i-1
			elseif(mod(n/N_frames,2)==1&& i==(n/N_frames))
				i=i-2
			endif
			allwave=wavelist("Slice*",";","")
			
			if ( itemsinlist(allwave,";") > N_frames )
				K=K+S
				NewDataFolder $NewWaveName+num2str(k)
			else
				K=K+S
				Killwaves/A
				break
			endif
			
			for(m=i*N_Frames;m<(i+1)*N_Frames; m+=1)
				movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
			endfor
			Duplicate/R=[i*N_Frames,m-1] ZStep, $ZNAME+num2str(k)
			Duplicate/R=[i*N_Frames,m-1] Depolarization, $DepName+num2str(k)
			movewave $ZNAME+num2str(k),:$NewWaveName+num2str(k):
			movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(i,PDepImon,";"), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(i,PDepVmon,";"), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(i,PDepImg,";"), :$NewWaveName+num2str(k):
			movewave $Stringfromlist(i,PDepLeak,";"), :$NewWaveName+num2str(k):
	
		endfor
		
	for(i=0;ItemsInList(Wavelist("slice*",";",""))>=N_frames;i+=2*N_frames)
			
		K=K+S
		NewDataFolder $NewWaveName+num2str(k)
			
		for(m=i;m<i+N_Frames; m+=1)
			movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
		endfor	
		Duplicate/R=[i,m-1] ZStep, $ZNAME+num2str(k)
		Duplicate/R=[i,m-1] Depolarization, $DepName+num2str(k)
		movewave $ZNAME+num2str(k),:$NewWaveName+num2str(k):
		movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
		movewave $Stringfromlist(i,PDepImon,";"), :$NewWaveName+num2str(k):
		movewave $Stringfromlist(i,PDepVmon,";"), :$NewWaveName+num2str(k):
		movewave $Stringfromlist(i,PDepImg,";"), :$NewWaveName+num2str(k):
		movewave $Stringfromlist(i,PDepLeak,";"), :$NewWaveName+num2str(k):
	
	endfor
	//
	else
		DFREF cDFR=GetDataFolderDFR()
		SetDataFolder PM
//		String PDepImon=Wavelist("PDep*1",";","")
//		String PDepVmon=Wavelist("PDep*2",";","")
//		String PDepLeak=Wavelist("PDep*3",";","")
             SetDataFolder cDFR
             tempK = -70
	     	k=tempK
	     	S = 10

		for(i=0;i<n-1;i+=N_Frames)
				NewDataFolder/O $NewWaveName+num2str(k)
				for(m=i;m<i+N_Frames; m+=1)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[i,m-1] Depolarization, $DepName+num2str(k)
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepImon,";"), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepVmon,";"), :$NewWaveName+num2str(k):
				movewave :PM:$Stringfromlist(i/N_Frames,PDepLeak,";"), :$NewWaveName+num2str(k):
				K=K+S	
		endfor
		
	endif
		
//////////////////////////////// IDENTIFYING DEPLOLARIZING FROM RESTING ///////////////////////////////////////////////////
	
	for(i=tempK;i<=k;i+=S)
		SetDataFolder $FolderName
		SetDataFolder :$NewWaveName+num2str(i)
		
		STRING CurrentWaves= Wavelist("Slice*",";","")


			wave w1=AvgFrame(1,5,"slice*","AvgRest")
			
			//create and move deltaF
//			for(j=0;j<N_Frames;j+=1)
//				MAKE/O/N=(80,80) TempWave
//				Duplicate/O $StringFromList(j,CurrentWaves), TempWave
//				Redimension/S TempWave
//				TempWave= TempWave - AvgRest
//				NewDataFolder/S DeltaF
//				Movewave TempWave, $StringFromList(j,CurrentWaves)
//				SetDataFolder $FolderName
//				SetDataFolder $NewWaveName+num2str(i)
//			endfor


			wave w2=AvgFrame(8,11,"slice*","AvgDep")						
			
			String Name
			
			make/O/n=(DimSize(AvgRest,0),DimSize(AvgRest,1)) dAvgDep
			dAvgDep = w2-w1
			
			Name = "AvgRest"
			Rename AvgRest, $Name+Num2str(i)
			Name = "AvgDep"
			Rename AvgDep, $Name+num2str(i)
			Name = "dAvgDep"
			Rename dAvgDep, $Name+num2str(i)
			
	Endfor
				
// Executing Autorun() inside
 	
End


Function FDJvFV(N_Frames,T_index)  //N_Frames: Number of frames per section ; N_DepFrame: Number of frames at depolarization
	VARIABLE N_Frames,T_index       // T_index: Data type, 0 = step scan, 1 = IV scan
	Print "Specify your working folder at first"
	
	Variable i,j,m,n,r1,p,S
	Variable num1,num2
	variable layNr,layOrIndex
	String allwave=Wavelist("TL*",";","")
	String ZName = "Z"
	String DepName = "Dep"
	String NewWaveName = "Slice"
	
	String FolderName = GetDataFolder(1)
	
//////////////////////////////////// RENAME THE WAVES AS A STANDARD ORDER ///////////////////////////////////////////
	
	n=ItemsInList(allwave,";")-1
	layNr=(n-1)/N_Frames
	layOrIndex=ceil(LayNr)	
		
	for(i=0;i<n;i+=1)			
		Rename $Stringfromlist(i,allwave,";") $NewWaveName+num2str(i)		
	Endfor
	
	String PDepImon=Wavelist("PDep*_1",";","")
	String PDepVmon=Wavelist("PDep*_2",";","")
	String PDepImg=Wavelist("PDep*_3",";","")
	String PDepLeak=Wavelist("PDep*_5",";","")
	
/////////////////////////////////// DIVIDE THE FILES TO DIFFERENT SLICES //////////////////////////////////////////////////////
	
	string BNCWaves=wavelist("*",";","DIMS:1")
	rename $stringfromlist(0,BNCWaves), Depolarization
	rename $stringfromlist(1,BNCWaves), ZStep
	rename $stringfromlist(2,BNCWaves), ICa
	variable tempK
	NVAR/Z K 
	
	variable ini 
	
	if(T_index == 0)
		if(NVAR_Exists(K)==1)
			NVAR K
			tempK=K
		else
			Variable/G K=-1
			tempK=0
		endif
		S=1
		// Identify the 1st section
		j=-2
				
		for(i=(n/N_frames);i>=0;i-=2)
			if(mod(n/N_frames,2)==1 && i==(n/N_frames))
				i=i-2
			elseif(mod(n/N_frames,2)==0&& i==(n/N_frames))
				i=i-1
			endif
			allwave=wavelist("Slice*",";","")
			
			if ( itemsinlist(allwave,";") > N_frames )
				K=K+S
				NewDataFolder $NewWaveName+num2str(k)
			else
				K=K+S
				Killwaves/A
				break
			endif
			
			for(m=i*N_Frames;m<(i+1)*N_Frames; m+=1)
				movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
			endfor
			Duplicate/R=[i*N_Frames,m-1] ZStep, $ZNAME+num2str(k)
			Duplicate/R=[i*N_Frames,m-1] Depolarization, $DepName+num2str(k)
			movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
			movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
		endfor
		
		if(i==0)
			ini=N_frames
		elseif(i<0)
			ini=0
		endif
		
		for(i=ini;ItemsInList(Wavelist("slice*",";",""))>=N_frames;i+=2*N_frames)
			
			K=K+S
			NewDataFolder $NewWaveName+num2str(k)
			
			for(m=i;m<i+N_Frames; m+=1)
				movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
			endfor	
			Duplicate/R=[i,m-1] ZStep, $ZNAME+num2str(k)
			Duplicate/R=[i,m-1] Depolarization, $DepName+num2str(k)
			movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
			movewave $ZNAME+num2str(k), :$NewWaveName+num2str(k):
	
		endfor
	//
	else
		DFREF cDFR=GetDataFolderDFR()
		SetDataFolder PM
//		String PDepImon=Wavelist("PDep*1",";","")
//		String PDepVmon=Wavelist("PDep*2",";","")
//		String PDepLeak=Wavelist("PDep*3",";","")
             SetDataFolder cDFR
             tempK = -70
	     	k=tempK
	     	S = 10

		for(i=0;i<n-1;i+=N_Frames)
				NewDataFolder/O $NewWaveName+num2str(k)
				for(m=i;m<i+N_Frames; m+=1)
					movewave $NewWaveName+num2str(m), :$NewWaveName+num2str(k):
				endfor
				Duplicate/R=[i,m-1] Depolarization, $DepName+num2str(k)
				movewave $DepNAME+num2str(k), :$NewWaveName+num2str(k):
				K=K+S	
		endfor
		
	endif
		
//////////////////////////////// IDENTIFYING DEPLOLARIZING FROM RESTING ///////////////////////////////////////////////////
	
	for(i=tempK;i<=k;i+=S)
		SetDataFolder $FolderName
		SetDataFolder :$NewWaveName+num2str(i)
		
		STRING CurrentWaves= Wavelist("Slice*",";","")


			wave AvgRest=AvgFrame(1,8,"slice*","AvgRest")
			
			
			//create and move deltaF
//			for(j=0;j<N_Frames;j+=1)
//				MAKE/O/N=(80,80) TempWave
//				Duplicate/O $StringFromList(j,CurrentWaves), TempWave
//				Redimension/S TempWave
//				TempWave= TempWave - AvgRest
//				NewDataFolder/S DeltaF
//				Movewave TempWave, $StringFromList(j,CurrentWaves)
//				SetDataFolder $FolderName
//				SetDataFolder $NewWaveName+num2str(i)
//			endfor


			Wave AvgDep=AvgFrame(21,26,"slice*","AvgDep")			
						
			
			String Name
			
			
			make/O/n=(DimSize(AvgRest,0),DimSize(AvgRest,1)) dAvgDep
			dAvgDep = AvgDep - AvgRest
			
			Name = "AvgRest"
			Rename AvgRest, $Name+Num2str(i)
			Name = "AvgDep"
			Rename AvgDep, $Name+num2str(i)
			Name = "dAvgDep"
			Rename dAvgDep, $Name+num2str(i)
			
	Endfor
				
// Executing Autorun() inside
 	
End

Function ReAvgImage()
	string Folders=ListFolder()
	DFREF home=GetDatafolderDFR()
	string AvgWaves,N1,N2,N3
	
	variable i,j
	for(i=0;i<ItemsInList(Folders)-1;i+=1)
		setdatafolder $stringfromlist(i,folders)
		avgwaves=wavelist("*avg*",";","")
		for(j=0;j<ItemsInList(avgwaves);j+=1)
			killwaves/Z $stringfromlist(j,avgwaves)
		endfor
		wave/Z image
		if(waveexists(image)==1)
			killwaves Image
		endif	
		wave w1=AvgFrame(1,8,"slice*","AvgRest")
		wave w2=AvgFrame(21,26,"slice*","AvgDep")
		make/O/n=(DimSize(w1,0),DimSize(w1,1)) dAvgDep
		dAvgDep=w2-w1
		N1="AvgRest"+num2str(i)
		N2="AvgDep"+num2str(i)
		N3="dAvgDep"+num2str(i)
		rename w1, $N1
		rename w2, $N2
		rename dAvgDep, $N3
		setdatafolder home
		
	endfor

end

Function PDJv2(oe)  //N_Frames: Number of frames per section ; N_DepFrame: Number of frames at depolarization
	VARIABLE oe //0:even 1:odd

	DFREF home=getdatafolderdfr()
	
	Variable i,j

	string AFolders=ListFolder()
	variable NoF= ItemsInList(AFolders)-2
	
//////////////////////////////////// RENAME THE WAVES AS A STANDARD ORDER ///////////////////////////////////////////
		
	String PDepImon=Wavelist("PDep*1",";","")
	String PDepVmon=Wavelist("PDep*2",";","")
	String PDepLeak=Wavelist("PDep*5",";","")
	String PDepAcqIm=Wavelist("PDep*3",";","")
//	for(i=0;i<ItemsInList(PDepImon);i+=1)
//		printf "%g,%s\r",i,stringfromlist(i,PDepImon) 
//	endfor
	
/////////////////////////////////// DIVIDE THE FILES TO DIFFERENT SLICES //////////////////////////////////////////////////////
	variable ini=1
		
		switch(oe)
			case 1:
				i=0
				for(j=NoF-1;j>=0;j-=2)				
					movewave $Stringfromlist(j,PDepImon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepVmon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepLeak,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepAcqIm,";"), :$StringFromList(i,AFolders,";"):

					i+=1
				endfor
				
				if(j!=0)
					ini=0
				endif
					
				for(j=ini;j<=NoF;j+=2)
					movewave $Stringfromlist(j,PDepImon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepVmon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepLeak,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepAcqIm,";"), :$StringFromList(i,AFolders,";"):
					i+=1
				endfor
				break				
			case 0:
				i=0
				for(j=NoF;j>=0;j-=2)	
					print Stringfromlist(j,PDepImon,";"),StringFromList(i,AFolders,";")		
					movewave $Stringfromlist(j,PDepImon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepVmon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepLeak,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepAcqIm,";"), :$StringFromList(i,AFolders,";"):
					i+=1
				endfor
				
				if(j!=0)
					ini=0
				endif
				
				for(j=ini;j<=NoF;j+=2)			
					movewave $Stringfromlist(j,PDepImon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepVmon,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepLeak,";"), :$StringFromList(i,AFolders,";"):
					movewave $Stringfromlist(j,PDepAcqIm,";"), :$StringFromList(i,AFolders,";"):
					i+=1
				endfor	
				break
		endswitch
	//
 	
End

function KickOutPP()
	string Folders=ListFolder()
	string AvgWaves
	DFREF home=getdatafolderdfr()
	
	variable i,j
	for(i=0;i<ItemsInList(Folders)-1;i+=1)
		setdatafolder $stringfromlist(i,folders)
		avgwaves=wavelist("*PDep*",";","")
		for(j=0;j<ItemsInList(avgwaves);j+=1)
			killwaves/Z $stringfromlist(j,avgwaves)
		endfor
		setdatafolder home
	endfor
end

function ImgSftSum(X1,Y1,X2,Y2,index)
	variable X1,Y1,X2,Y2,index
	
	switch(index)	
		case 0:
			DFREF home=getDataFolderDFR()
			Setdatafolder :CaFV1:
			DFREF F1=GetDataFolderDFR()
			string FF1=ListFolder()
			setdatafolder home
			Setdatafolder :CaFV2:
			DFREF F2=GetDataFolderDFR()
			string FF2=ListFolder()
			setdatafolder home
			
	
			NewDataFolder/S SumFV
			DFREF Dest=GetDataFolderDFR()
			break
		case 1:
			DFREF home=getDataFolderDFR()
			Setdatafolder :CaFV3:
			DFREF F1=GetDataFolderDFR()
			FF1=ListFolder()
			setdatafolder home
			Setdatafolder :SumFV:
			DFREF F2=GetDataFolderDFR()
			FF2=ListFolder()
			setdatafolder home
				
			NewDataFolder/S CaFV
			DFREF Dest=GetDataFolderDFR()
			break		
			break
	endswitch
	
	variable i,j,px,py
	string aWn1,aWn2,aNw,nFname
	string NewN,cmd
	
	for(i=0;i<ItemsInList(FF1)-4;i+=1)		
		setdatafolder F1
		setdatafolder $stringfromlist(i,FF1)
		DFREF FD1=getdatafolderdfr()
		aWn1=Wavelist("slice*",";","")
		setdatafolder F2
		switch(index)
			case 0:
				setdatafolder $stringfromlist(i,FF2)
				DFREF FD2=getdatafolderdfr()
				aWn2=Wavelist("slice*",";","")
				break
			case 1:
				setdatafolder $stringfromlist(i,FF2)
				DFREF FD2=getdatafolderdfr()
				aWn2=Wavelist("sliceS_*",";","")				
				break
		endswitch
		setdatafolder FD1
		
		for(j=0;j<ItemsInList(aWn1);j+=1)
			switch(index)
				case 0:
					NewN="SliceS_"+num2str(j)
					killwaves/Z $NewN
					break
				case 1:
					NewN="Slice"+num2str(j)			
					break
			endswitch
			
			
			make/O/n=(80+abs(X1-X2),80+abs(Y1-Y2)) SUMim				
			wave w1=$stringfromlist(j,aWn1)
			for(px=0;px<80;px+=1)
				for(py=0;py<80;py+=1)
					if(X1-X2<0)
						if(Y1-Y2<0)
							SUMim[Px][Py]=w1[Px][Py]
						else
							SUMim[Px][Py+abs(y1-y2)]=w1[Px][Py]
						endif	
					else
						if(Y1-Y2<0)
							SUMim[Px+abs(x1-x2)][Py]=w1[Px][Py]
						else
							SUMim[Px+abs(x1-x2)][Py+abs(y1-y2)]=w1[Px][Py]
						endif			
					endif
				endfor
			endfor			
			
			setdatafolder FD2
			killwaves/Z $NewN
			
			setdatafolder FD1
			movewave SUMim, FD2
			setdatafolder FD2
				
			for(px=0;px<80;px+=1)
				for(py=0;py<80;py+=1)
					wave w2=$stringfromlist(j,aWn2)
					if(X1-X2<0)
						if(Y1-Y2<0)
							SUMim[Px][Py]=SUMim[Px][Py]+w2[Px][Py]
						else
							SUMim[Px][Py+abs(y1-y2)]=Sumim[Px][Py+abs(y1-y2)]+w2[Px][Py]
						endif	
					else
						if(Y1-Y2<0)
							SUMim[Px+abs(x1-x2)][Py]=SUMim[Px+abs(x1-x2)][Py]+w2[Px][Py]
						else
							SUMim[Px+abs(x1-x2)][Py+abs(y1-y2)]=SUMim[Px+abs(x1-x2)][Py+abs(y1-y2)]+w2[Px][Py]
						endif			
					endif
				endfor
			endfor
			
			if(X1-X2<0)
				deletepoints/M=0 80,abs(x1-x2),SumIm
				if(Y1-Y2<0)
					deletepoints/M=1 80,abs(y1-y2),SumIm
				else
					deletepoints/M=1 0,abs(y1-y2),SumIm
				endif
			else
				deletepoints/M=0 0,abs(x1-x2),SumIm
				if(Y1-Y2<0)
					deletepoints/M=1 80,abs(y1-y2),SumIm
				else
					deletepoints/M=1 0,abs(y1-y2),SumIm
				endif
			endif
			
					
			movewave SumIm,Dest
			setdatafolder Dest
			rename SumIm,$NewN
			setdatafolder FD1				
		endfor
		setdatafolder Dest
		switch(index)
			case 0:
				nFname="sliceS"+num2str(i)
				newdatafolder $nFname
				aNw=wavelist("SliceS_*",";","")
				break
			case 1:
				nFname="slice"+num2str(i)
				newdatafolder $nFname
				aNw=wavelist("Slice*",";","")				
				break
		endswitch
				
		for(j=0;j<ItemsInList(aNw);j+=1)
			switch(index)
				case 1:
					wavecalculatorV(3,3,$stringfromlist(j,aNw))
					break
				case 0:
					break
			endswitch
			sprintf cmd, "movewave :%s, :%s:",stringfromlist(j,aNw),nFname
			execute cmd
		endfor		
	endfor
	
	switch(index)
		case 1:
			break
		case 0:
			Setdatafolder Dest
			ReAvgImage()
			Imageoutput()
			setdatafolder ZStack_DeltaF
			for(i=0;i<ItemsInList(wavelist("davg*",";",""));i+=1)
				wavecalculatorv(3,2,$stringfromlist(i,wavelist("davg*",";","")))
			endfor
			break
	endswitch
		
end

function copyPPTrace()
	DFREF home=getdatafolderDFR()
	setdatafolder CaFV1
	DFREF Source=getdatafolderDFR()
	setdatafolder home
	setdatafolder CaFV
	DFREF Dest=getdatafolderDFR()
	string aF=ListFolder()
	setdatafolder home
	
	
	
	string PPTrace
	variable n=ItemsInList(aF)-4
	variable i,j
	for(i=0;i<ItemsInList(aF)-4;i+=1)
		setdatafolder Dest
		setdatafolder $stringfromlist(i,ListFolder())
		DFREF Dest2=getdatafolderDFR()
		setdatafolder Source
		setdatafolder $stringfromlist(i,ListFolder())
		PPTrace=wavelist("PDEP*",";","")
		for(j=0;j<3;j+=1)
			duplicate/O $stringfromlist(j,PPTrace), Dest2:$stringfromlist(j,PPTrace)
		endfor
	endfor
	
end


function ImgSftavg(X1,Y1,X2,Y2)
	variable X1,Y1,X2,Y2
	
	DFREF home=getDataFolderDFR()
	Setdatafolder :CaFV3:ZStack_DeltaF
	DFREF F1=GetDataFolderDFR()
	string ImwF1=wavelist("davg*",";","")
	setdatafolder home
	Setdatafolder :SUMim
	DFREF F2=GetDataFolderDFR()
	string ImwF2=wavelist("davg*",";","")
	setdatafolder home
	
	NewDataFolder/S Avgim
	DFREF Dest=GetDataFolderDFR()
	variable i,px,py
	string NewN
	
	for(i=0;i<ItemsInList(ImwF1);i+=1)
		setdatafolder F1
		make/n=(80+abs(X1-X2),80+abs(Y1-Y2)) SUMim
		wave w1=$stringfromlist(i,ImwF1)
		for(px=0;px<80;px+=1)
			for(py=0;py<80;py+=1)
				if(X1-X2<0)
					if(Y1-Y2<0)
						SUMim[Px][Py]=w1[Px][Py]
					else
						SUMim[Px][Py+abs(y1-y2)]=w1[Px][Py]
					endif	
				else
					if(Y1-Y2<0)
						SUMim[Px+abs(x1-x2)][Py]=w1[Px][Py]
					else
						SUMim[Px+abs(x1-x2)][Py+abs(y1-y2)]=w1[Px][Py]
					endif			
				endif
			endfor
		endfor
		movewave SUMim, F2
		setdatafolder F2
		for(px=0;px<80;px+=1)
			for(py=0;py<80;py+=1)
			wave w2=$stringfromlist(i,ImwF2)
				if(X1-X2<0)
					if(Y1-Y2<0)
						SUMim[Px][Py]=SUMim[Px][Py]+w2[Px][Py]
					else
						SUMim[Px][Py+abs(y1-y2)]=Sumim[Px][Py+abs(y1-y2)]+w2[Px][Py]
					endif	
				else
					if(Y1-Y2<0)
						SUMim[Px+abs(x1-x2)][Py]=SUMim[Px+abs(x1-x2)][Py]+w2[Px][Py]
					else
						SUMim[Px+abs(x1-x2)][Py+abs(y1-y2)]=SUMim[Px+abs(x1-x2)][Py+abs(y1-y2)]+w2[Px][Py]
					endif			
				endif
			endfor
		endfor
		if(X1-X2<0)
			deletepoints/M=0 80,abs(x1-x2),SumIm
			if(Y1-Y2<0)
				deletepoints/M=1 80,abs(y1-y2),SumIm
			else
				deletepoints/M=1 0,abs(y1-y2),SumIm
			endif
		else
			deletepoints/M=0 0,abs(x1-x2),SumIm
			if(Y1-Y2<0)
				deletepoints/M=1 80,abs(y1-y2),SumIm
			else
				deletepoints/M=1 0,abs(y1-y2),SumIm
			endif
		endif
		NewN="davgS_"+num2str(i)		
		movewave SumIm,Dest
		setdatafolder Dest
		wavecalculatorV(3,3,SumIm)
		rename SumIm,$NewN
		setdatafolder F1		
	endfor
	setdatafolder dest
	ThreeDStack("davg*")
	wave Time_stack
	rename Time_Stack, Avg_stack
	setdatafolder home		
end

function Assign3DwaveJump(key)
	string key
	
	string aw=wavelist(key,";","")
	aw = sortlist (aw, ";", 0)
	string FolderN,tempN
	variable NrL=ItemsInList(aw)
//		     NrL=19
	variable i,j=1
	
	for(i=0;i<NrL;i+=1)
		FolderN="Section_"+num2str(i)
		NewDataFolder/O $FolderN		
	endfor
	
	DFREF home=GetDataFolderDFR()
	
	j=NrL-1
	for(i=NrL-1;i>=0;i-=2)		
		FolderN="Section_"+num2str(j)
		SetDataFolder $FolderN
		DFREF Dest=GetDataFolderDFR()
		setdatafolder home
		wave w=$StringFromList(i,aw)
		movewave w, Dest
		j=j-1
	endfor
	
	j=0
	for(i=NrL-2;i>0;i-=2)
		FolderN="Section_"+num2str(j)
		SetDataFolder $FolderN
		DFREF Dest=GetDataFolderDFR()
		setdatafolder home
		wave w=$StringFromList(i,aw)
		movewave w, Dest
		j=j+1
	endfor	
end

function Assign3DPatchCurrent(key)
	string key
	
	string aw=wavelist(key,";","")
	string FolderN,tempN
	variable NrL=ItemsInList(aw)
	variable i,j=1
	
	for(i=0;i<NrL;i+=1)
		FolderN="Section_"+num2str(i)
		NewDataFolder/O $FolderN		
	endfor
	
	DFREF home=GetDataFolderDFR()
	
	j=NrL-1
	for(i=NrL-1;i>=0;i-=2)		
		FolderN="Section_"+num2str(j)
		SetDataFolder $FolderN
		DFREF Dest=GetDataFolderDFR()
		setdatafolder home
		wave w=$StringFromList(i,aw)
		movewave w, Dest
		j=j-1
	endfor
	
	j=0
	for(i=NrL-2;i>0;i-=2)
		FolderN="Section_"+num2str(j)
		SetDataFolder $FolderN
		DFREF Dest=GetDataFolderDFR()
		setdatafolder home
		wave w=$StringFromList(i,aw)
		movewave w, Dest
		j=j+1
	endfor	
end

function CombineWaves()
	
	string aF=ListFolder()
	string aw
	string FolderN,NewName
	variable NrF=ItemsInList(aF)-1

	DFREF home=GetDataFolderDFR()
	
	variable Ndp,i,k,j,m,n
	for(i=0;i<NrF;i+=1)
		NewName="Section_"+num2str(i)
		SetDataFolder $stringfromlist(i,aF)
		aw=wavelist("*",";","")
		wave w1=$stringfromlist(0,aw)
		duplicate/O w1,$NewName
		wave w=$NewName
		wave w2=$stringfromlist(1,aw)	
		Ndp=DimSize(w1,2)
		
		n=1
		do
			insertpoints/M=2 n,1,w
			n=n+2
		while(n<Ndp*2)
		
		duplicate/O w,wt
		
		n=0		
		for(m=0;m<Ndp;m+=1)
			for(j=0;j<DimSize(w,0);j+=1)
				for(k=0;k<DimSize(w,1);k+=1)				
					w[j][k][n+1]=w2[j][k][m]
				endfor
			endfor
			n=n+2			
		endfor
					
		setdatafolder home
	endfor

end

function Avg3DStack(sti,ste,rsi,rse,key)
	variable sti,ste,rsi,rse //14,19,1,10 for FV 17,22,1,10 for Dep
	string key // Searching for waves as key indicates

	string aF=ListFolder()
	string OriName,RsName
	variable nF=ItemsInList(aF)-1
	variable i
	string wavg1N,wavg2N
	DFREF home=GetDataFolderDFR()
	for(i=0;i<nF;i+=1)
			SetDataFolder $stringfromlist(i,aF)
			OriName= stringfromlist(0,wavelist(key,";",""))
			wave wori=$OriName 
			wave wavgt=AvgIn3DWave(Sti,Ste,wori)
			wavg1N=NameOfWave(wavgt)+"ST"
			rename wavgt,$wavg1N
			wave wavg=$wavg1N
			wave wavg2t=AvgIn3DWave(Rsi,Rse,wori)
			wavg2N=NameOfWave(wavg2t)+"Rest"
			rename wavg2t,$wavg2N
			wave wavg2=$wavg2N
			wave ss=wavecalculatorw(1,wavg,wavg2)
			RsName = NameOfWave(wavg)+"_ST"
			Rename wavg , $RsName
			movewave wavg , home:wavg
			RsName = NameOfWave(wavg2)+"_Rest"
			Rename wavg2, $RsName
			movewave wavg2, home:wavg2
			RsName = NameOfWave(wavg)+"_DF"
			Rename ss, $RsName
			movewave ss,home:ss			
		setdatafolder home
		concatenate/KILL/NP=2 {wavg}, Stack_ST
		concatenate/KILL/NP=2 {wavg2}, Stack_Rest
		concatenate/KILL/NP=2 {ss}, Stack_DF 
	endfor
	
end





