#pragma rtGlobals=3		// Use modern global access method and strict wave access.

function LGS () //Let´s get started
	NewDataFolder $"2"
	NewDataFolder FV
	NewDataFolder PatchClamp
	NewDataFolder IV
	NewDataFolder out
	LoadNeoFITS()
end

Function RePrefix(s1, s2) //The following script is to change the name of a series of file. 
	
   string s1,s2 //s1 is the current part of the name that has to be change, s2 is the future part
   
//   string CD051214mut,CD051214
 
   string theList, theOne, theName
   variable ic, nt
 
   
    
   theList = WaveList(s1+"*",";","")
   nt = ItemsInList(theList)
   for (ic=0;ic<nt;ic+=1)
     theOne = StringFromList(ic,theList)
     theName = ReplaceString(s1,theOne,s2)
     rename $theOne $theName
   endfor
   return 0
end

function FVinfooutput(algo)
	variable algo             //Here you select the algorithm to find the initial guesses: 1=RefineFV_fixVr, 2=RefineFVnew (or any thing different to 1)
	string aF=ListFolder()
	variable i
	variable CaInt
	DFREF home=GetDataFolderDFR()
	for(i=0;i<ItemsInList(aF)-1;i+=1)
		setdatafolder $stringfromlist(i,aF)
//		RenameDataFolder RefineFV, RefineFV_old
		If(DataFolderExists("RefineFV_Vr")==1)
			killdatafolder RefineFV_Vr
		endif
		
		if (algo==1)
			Wave Fit1=RefineFV_fixvr()            //Fitting Algorithm
		else
			Wave Fit1=RefineFVnew2()         //Fitting Algorithm
		endif
		
		wave Result=NormalizedFitFV(Fit1)
		wave FVTru=$"FV"
//		wave IniGuess
		duplicate/R=[][0,0] Result, CaInfo
		Insertpoints/M=0 0,1,CaInfo
		CaInt=mean(FVTru,pnt2x(FVTru,53),pnt2x(FVTru,58)) //Choose the correct range for F max - look also at the peak current in the IV 
		CaInfo[0][0] = CaInt
		matrixtranspose CaInfo		
		Redimension/N=(1,-1) CaInfo
		movewave CaInfo, home
		setdatafolder home
		concatenate/KILL/NP=0 {CaInfo}, CaInfo_Cor
	endfor

end

function GetOldInfo()
	string aF=ListFolder()
	variable i
	variable CaInt
	DFREF home=GetDataFolderDFR()
	for(i=0;i<ItemsInList(aF)-1;i+=1)
		setdatafolder $stringfromlist(i,aF)
		SetDataFolder RefineFV_Old
		wave IniGuess
		duplicate/R=[][0,0] IniGuess, w_coef
		matrixtranspose w_coef		
		Redimension/N=(1,-1) w_coef
		movewave w_coef, home
		wave/Z CaInfo_ALL_Old
		if(waveexists(CaInfo_ALL_old)==1)
			killwaves CaInfo_ALL_Old
		endif
		SetDataFolder home 
		concatenate/KILL/NP=0 {W_Coef}, CaInfo_ALL_Old		
	endfor
end

Function AutoALLIV()
	string aF=ListFolder()
	variable i
	DFREF home=GetDataFolderDFR()
	for(i=0;i<ItemsInList(aF);i+=1)
		setdatafolder $stringfromlist(i,aF)
		AutoIV(1,1,"")
		setdatafolder home
	endfor
end

function ConcatenateAcrossFolders(str1,str2)
	string str1,str2
	string aF=ListFolders(str1)
	string WavNam= str2+"_ALL"
	variable i
	DFREF home=GetDataFolderDFR()
	for(i=0;i<ItemsInList(aF);i+=1)
		SetDataFolder $StringFromList(i,aF)
//		setdatafolder MPR
//		setdatafolder IV
		wave w=$str2
//		print dimsize(w,1)
		duplicate/O w, home:$str2		
		SetDataFolder home
		wave dd=home:$str2
//		matrixtranspose dd
		concatenate/NP=0/KILL {dd}, $WavNam
	
	endfor
	
end

//This is the piece of code that you have to execute after importing your data

//This 2 lines order the images 
Assign3DwaveJump("CD*1.tif")
Assign3DwaveJump("CD*2.tif")

//These lines calculate  DF, DF/F0, F0 over the whole Z scannings and display DF/F0

Avg3DStack(14,19,1,10,"CD*1.tif")
rename Stack_ST, Stack_ST_1
rename Stack_Rest, Stack_Rest_1
rename Stack_DF, Stack_DF_1
NewImage Stack_DF_1;ModifyImage Stack_DF_1 plane=0
ModifyGraph height={Aspect,0.75}
SliderGeo()

Avg3DStack(14,19,1,10,"CD*2.tif")
rename Stack_ST, Stack_ST_2
rename Stack_Rest, Stack_Rest_2
rename Stack_DF, Stack_DF_2
NewImage Stack_DF_2;ModifyImage Stack_DF_2 plane=0
ModifyGraph height={Aspect,0.75}
SliderGeo()

//////////////////////////////////////////////////////////////////////////////////////////////////



NewImage '*_01.tif';ModifyImage '*_01.tif' plane=0



Avg3DStack(5,9,1,3,"*")


function addit()
	ShowInfo	
	WMAppend3DImageSlider()
end




function AssignPatchData(i)
	//Old Igor files have Imon Vmon and Adc1 (before 25/10/15), new have I-mon V-mon and Adc-1
	variable i
	string wn="PMPulse_"+num2str(i)+"_*_1_1_I-mon"
	Assign3DPatchCurrent(wn)
	wn="PMPulse_"+num2str(i)+"_*_2_1_I-mon"
	Assign3DPatchCurrent(wn)	
	wn="PMPulse_"+num2str(i)+"_*_1_2_V-mon"
	Assign3DPatchCurrent(wn)
	wn="PMPulse_"+num2str(i)+"_*_2_2_V-mon"
	Assign3DPatchCurrent(wn)
	wn="PMPulse_"+num2str(i)+"_*_1_3_Adc-1"
	Assign3DPatchCurrent(wn)
	wn="PMPulse_"+num2str(i)+"_*_2_3_Adc-1"
	Assign3DPatchCurrent(wn)
	wn="PMPulse_"+num2str(i)+"_*_1_4_Leak_1"
	Assign3DPatchCurrent(wn)
	wn="PMPulse_"+num2str(i)+"_*_2_4_Leak_1"
	Assign3DPatchCurrent(wn)			
	RscAcrossFolders(0.01)
	
end

function GetRealFmax()
	
	string F1=ListFolder()
	variable i,j,Int
	for(i=0;i<ItemsInList(F1)-1;i+=1)
		SetDataFolder $StringFromList(i,F1)
		DFREF TempHome=GetDataFolderDFR()
		string F2=ListFolder()
		make/n=(ItemsInList(F2)-1) Intensity
		for(j=0;j<ItemsInList(F2)-1;j+=1)
			SetDataFolder $StringFromList(j,F2)
			wave w=$"Ratio_Spot0"
			Int = mean(w,pnt2x(w,48),pnt2x(w,54))
			SetDataFolder TempHome
			Intensity[j]=Int
		endfor
		movewave Intensity, Root:
		SetDataFolder Root:
		Concatenate/NP=0/KILL {Intensity}, CaInt_ALL
	endfor

end

function GetParameterMax()
	
	string F1=ListFolder()
	variable i,j,Int
	for(i=0;i<ItemsInList(F1)-1;i+=1)
		SetDataFolder $StringFromList(i,F1)
		wave/Z w=$"CaInfo_combined"
		if(waveexists(w)==0)
			wave/Z w=$"CaInfo_ALL"
			if(waveexists(w)==0)
				print StringFromList(i,F1)
				return 0
			endif
		endif
		duplicate w, Root:M_Par
		SetDataFolder Root:
		wave M_Par
		Concatenate/NP=0/KILL {M_Par}, Par_ALL
	endfor
	
end

